@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The role management policy approval rule.
 * @property id The id of the rule.
 * @property ruleType The type of rule
 * Expected value is 'RoleManagementPolicyApprovalRule'.
 * @property setting The approval setting
 * @property target The target of the current rule.
 */
public data class RoleManagementPolicyApprovalRuleResponse(
    public val id: String? = null,
    public val ruleType: String,
    public val setting: ApprovalSettingsResponse? = null,
    public val target: RoleManagementPolicyRuleTargetResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.RoleManagementPolicyApprovalRuleResponse):
            RoleManagementPolicyApprovalRuleResponse = RoleManagementPolicyApprovalRuleResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            setting = javaType.setting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.ApprovalSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.RoleManagementPolicyRuleTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
