@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The role management policy expiration rule.
 * @property id The id of the rule.
 * @property isExpirationRequired The value indicating whether expiration is required.
 * @property maximumDuration The maximum duration of expiration in timespan.
 * @property ruleType The type of rule
 * Expected value is 'RoleManagementPolicyExpirationRule'.
 * @property target The target of the current rule.
 */
public data class RoleManagementPolicyExpirationRuleResponse(
    public val id: String? = null,
    public val isExpirationRequired: Boolean? = null,
    public val maximumDuration: String? = null,
    public val ruleType: String,
    public val target: RoleManagementPolicyRuleTargetResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.RoleManagementPolicyExpirationRuleResponse):
            RoleManagementPolicyExpirationRuleResponse = RoleManagementPolicyExpirationRuleResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isExpirationRequired = javaType.isExpirationRequired().map({ args0 -> args0 }).orElse(null),
            maximumDuration = javaType.maximumDuration().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.RoleManagementPolicyRuleTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
