@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The detail of a user.
 * @property description The description of the user.
 * @property id The object id of the user.
 * @property isBackup The value indicating whether the user is a backup fallback approver
 * @property userType The type of user.
 */
public data class UserSetResponse(
    public val description: String? = null,
    public val id: String? = null,
    public val isBackup: Boolean? = null,
    public val userType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.UserSetResponse):
            UserSetResponse = UserSetResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isBackup = javaType.isBackup().map({ args0 -> args0 }).orElse(null),
            userType = javaType.userType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
