@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePropertiesResponse
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePropertiesResponse.Companion.toKotlin as configurationProfilePropertiesResponseToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationProfilesVersion].
 */
@PulumiTagMarker
public class ConfigurationProfilesVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfilesVersionArgs = ConfigurationProfilesVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfilesVersionArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfilesVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationProfilesVersion {
        val builtJavaResource =
            com.pulumi.azurenative.automanage.ConfigurationProfilesVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfilesVersion(builtJavaResource)
    }
}

/**
 * Definition of the configuration profile.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update configuration profile version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfilesVersion = new AzureNative.Automanage.ConfigurationProfilesVersion("configurationProfilesVersion", new()
 *     {
 *         ConfigurationProfileName = "customConfigurationProfile",
 *         Location = "East US",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfilePropertiesArgs
 *         {
 *             Configuration = new Dictionary<string, object?>
 *             {
 *                 ["Antimalware/Enable"] = false,
 *                 ["AzureSecurityCenter/Enable"] = true,
 *                 ["Backup/Enable"] = false,
 *                 ["BootDiagnostics/Enable"] = true,
 *                 ["ChangeTrackingAndInventory/Enable"] = true,
 *                 ["GuestConfiguration/Enable"] = true,
 *                 ["LogAnalytics/Enable"] = true,
 *                 ["UpdateManagement/Enable"] = true,
 *                 ["VMInsights/Enable"] = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *         VersionName = "version1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfilesVersion(ctx, "configurationProfilesVersion", &automanage.ConfigurationProfilesVersionArgs{
 * 			ConfigurationProfileName: pulumi.String("customConfigurationProfile"),
 * 			Location:                 pulumi.String("East US"),
 * 			Properties: &automanage.ConfigurationProfilePropertiesArgs{
 * 				Configuration: pulumi.Any(map[string]interface{}{
 * 					"Antimalware/Enable":                false,
 * 					"AzureSecurityCenter/Enable":        true,
 * 					"Backup/Enable":                     false,
 * 					"BootDiagnostics/Enable":            true,
 * 					"ChangeTrackingAndInventory/Enable": true,
 * 					"GuestConfiguration/Enable":         true,
 * 					"LogAnalytics/Enable":               true,
 * 					"UpdateManagement/Enable":           true,
 * 					"VMInsights/Enable":                 true,
 * 				}),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 			VersionName: pulumi.String("version1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilesVersion;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilesVersionArgs;
 * import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfilesVersion = new ConfigurationProfilesVersion("configurationProfilesVersion", ConfigurationProfilesVersionArgs.builder()
 *             .configurationProfileName("customConfigurationProfile")
 *             .location("East US")
 *             .properties(ConfigurationProfilePropertiesArgs.builder()
 *                 .configuration(Map.ofEntries(
 *                     Map.entry("Antimalware/Enable", false),
 *                     Map.entry("AzureSecurityCenter/Enable", true),
 *                     Map.entry("Backup/Enable", false),
 *                     Map.entry("BootDiagnostics/Enable", true),
 *                     Map.entry("ChangeTrackingAndInventory/Enable", true),
 *                     Map.entry("GuestConfiguration/Enable", true),
 *                     Map.entry("LogAnalytics/Enable", true),
 *                     Map.entry("UpdateManagement/Enable", true),
 *                     Map.entry("VMInsights/Enable", true)
 *                 ))
 *                 .build())
 *             .resourceGroupName("myResourceGroupName")
 *             .tags(Map.of("Organization", "Administration"))
 *             .versionName("version1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfilesVersion customConfigurationProfile/version1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}/versions/{versionName}
 * ```
 */
public class ConfigurationProfilesVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.automanage.ConfigurationProfilesVersion,
) : KotlinCustomResource(javaResource, ConfigurationProfilesVersionMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the configuration profile.
     */
    public val properties: Output<ConfigurationProfilePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationProfilePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfilesVersionMapper : ResourceMapper<ConfigurationProfilesVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automanage.ConfigurationProfilesVersion::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfilesVersion =
        ConfigurationProfilesVersion(
            javaResource as
                com.pulumi.azurenative.automanage.ConfigurationProfilesVersion,
        )
}

/**
 * @see [ConfigurationProfilesVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfilesVersion].
 */
public suspend fun configurationProfilesVersion(
    name: String,
    block: suspend ConfigurationProfilesVersionResourceBuilder.() -> Unit,
):
    ConfigurationProfilesVersion {
    val builder = ConfigurationProfilesVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfilesVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfilesVersion(name: String): ConfigurationProfilesVersion {
    val builder = ConfigurationProfilesVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
