@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceAntiMalwareArgs.builder
import com.pulumi.azurenative.automanage.kotlin.enums.EnableRealTimeProtection
import com.pulumi.azurenative.automanage.kotlin.enums.RunScheduledScan
import com.pulumi.azurenative.automanage.kotlin.enums.ScanType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Automanage configuration profile Antimalware preferences.
 * @property enableRealTimeProtection Enables or disables Real Time Protection
 * @property exclusions Extensions, Paths and Processes that must be excluded from scan
 * @property runScheduledScan Enables or disables a periodic scan for antimalware
 * @property scanDay Schedule scan settings day
 * @property scanTimeInMinutes Schedule scan settings time
 * @property scanType Type of scheduled scan
 */
public data class ConfigurationProfilePreferenceAntiMalwareArgs(
    public val enableRealTimeProtection: Output<Either<String, EnableRealTimeProtection>>? = null,
    public val exclusions: Output<Any>? = null,
    public val runScheduledScan: Output<Either<String, RunScheduledScan>>? = null,
    public val scanDay: Output<String>? = null,
    public val scanTimeInMinutes: Output<String>? = null,
    public val scanType: Output<Either<String, ScanType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceAntiMalwareArgs> {
    override fun toJava():
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceAntiMalwareArgs =
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceAntiMalwareArgs.builder()
            .enableRealTimeProtection(
                enableRealTimeProtection?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .exclusions(exclusions?.applyValue({ args0 -> args0 }))
            .runScheduledScan(
                runScheduledScan?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scanDay(scanDay?.applyValue({ args0 -> args0 }))
            .scanTimeInMinutes(scanTimeInMinutes?.applyValue({ args0 -> args0 }))
            .scanType(
                scanType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationProfilePreferenceAntiMalwareArgs].
 */
@PulumiTagMarker
public class ConfigurationProfilePreferenceAntiMalwareArgsBuilder internal constructor() {
    private var enableRealTimeProtection: Output<Either<String, EnableRealTimeProtection>>? = null

    private var exclusions: Output<Any>? = null

    private var runScheduledScan: Output<Either<String, RunScheduledScan>>? = null

    private var scanDay: Output<String>? = null

    private var scanTimeInMinutes: Output<String>? = null

    private var scanType: Output<Either<String, ScanType>>? = null

    /**
     * @param value Enables or disables Real Time Protection
     */
    @JvmName("osfqycchkoeylkev")
    public suspend
    fun enableRealTimeProtection(`value`: Output<Either<String, EnableRealTimeProtection>>) {
        this.enableRealTimeProtection = value
    }

    /**
     * @param value Extensions, Paths and Processes that must be excluded from scan
     */
    @JvmName("kufxrbjjgqmbyybk")
    public suspend fun exclusions(`value`: Output<Any>) {
        this.exclusions = value
    }

    /**
     * @param value Enables or disables a periodic scan for antimalware
     */
    @JvmName("arxpjgkblmccketo")
    public suspend fun runScheduledScan(`value`: Output<Either<String, RunScheduledScan>>) {
        this.runScheduledScan = value
    }

    /**
     * @param value Schedule scan settings day
     */
    @JvmName("khubgsjvkbdrahba")
    public suspend fun scanDay(`value`: Output<String>) {
        this.scanDay = value
    }

    /**
     * @param value Schedule scan settings time
     */
    @JvmName("yolmisfdfgyadjff")
    public suspend fun scanTimeInMinutes(`value`: Output<String>) {
        this.scanTimeInMinutes = value
    }

    /**
     * @param value Type of scheduled scan
     */
    @JvmName("kopwcjeacgcslgkf")
    public suspend fun scanType(`value`: Output<Either<String, ScanType>>) {
        this.scanType = value
    }

    /**
     * @param value Enables or disables Real Time Protection
     */
    @JvmName("ltglerbmyhgikhmc")
    public suspend fun enableRealTimeProtection(`value`: Either<String, EnableRealTimeProtection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRealTimeProtection = mapped
    }

    /**
     * @param value Enables or disables Real Time Protection
     */
    @JvmName("lkphcfudlujblhch")
    public fun enableRealTimeProtection(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableRealTimeProtection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableRealTimeProtection = mapped
    }

    /**
     * @param value Enables or disables Real Time Protection
     */
    @JvmName("gksjggdielxphmqw")
    public fun enableRealTimeProtection(`value`: EnableRealTimeProtection) {
        val toBeMapped = Either.ofRight<String, EnableRealTimeProtection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableRealTimeProtection = mapped
    }

    /**
     * @param value Extensions, Paths and Processes that must be excluded from scan
     */
    @JvmName("qeygcekkbclkaswr")
    public suspend fun exclusions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value Enables or disables a periodic scan for antimalware
     */
    @JvmName("pydqqukxrfqgwfwl")
    public suspend fun runScheduledScan(`value`: Either<String, RunScheduledScan>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runScheduledScan = mapped
    }

    /**
     * @param value Enables or disables a periodic scan for antimalware
     */
    @JvmName("lkuiqmjaxguqfomt")
    public fun runScheduledScan(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RunScheduledScan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runScheduledScan = mapped
    }

    /**
     * @param value Enables or disables a periodic scan for antimalware
     */
    @JvmName("tllaverkcrutvdij")
    public fun runScheduledScan(`value`: RunScheduledScan) {
        val toBeMapped = Either.ofRight<String, RunScheduledScan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runScheduledScan = mapped
    }

    /**
     * @param value Schedule scan settings day
     */
    @JvmName("qwkycnimmmqiyuei")
    public suspend fun scanDay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanDay = mapped
    }

    /**
     * @param value Schedule scan settings time
     */
    @JvmName("vohnldscedkjsojv")
    public suspend fun scanTimeInMinutes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanTimeInMinutes = mapped
    }

    /**
     * @param value Type of scheduled scan
     */
    @JvmName("kbuvnjxywvnbmuoa")
    public suspend fun scanType(`value`: Either<String, ScanType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    /**
     * @param value Type of scheduled scan
     */
    @JvmName("iaqtddxwrwjcnugy")
    public fun scanType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScanType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    /**
     * @param value Type of scheduled scan
     */
    @JvmName("yamigevfvgurknnk")
    public fun scanType(`value`: ScanType) {
        val toBeMapped = Either.ofRight<String, ScanType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    internal fun build(): ConfigurationProfilePreferenceAntiMalwareArgs =
        ConfigurationProfilePreferenceAntiMalwareArgs(
            enableRealTimeProtection = enableRealTimeProtection,
            exclusions = exclusions,
            runScheduledScan = runScheduledScan,
            scanDay = scanDay,
            scanTimeInMinutes = scanTimeInMinutes,
            scanType = scanType,
        )
}
