@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationProfileName The configuration profile name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConfigurationProfilePlainArgs(
    public val configurationProfileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePlainArgs =
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePlainArgs.builder()
            .configurationProfileName(configurationProfileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfilePlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfilePlainArgsBuilder internal constructor() {
    private var configurationProfileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The configuration profile name.
     */
    @JvmName("fdlenahymeyepibm")
    public suspend fun configurationProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("njwxkoblecdlaoup")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationProfilePlainArgs = GetConfigurationProfilePlainArgs(
        configurationProfileName = configurationProfileName ?: throw
            PulumiNullFieldException("configurationProfileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
