@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.ContentSourceResponse
import com.pulumi.azurenative.automation.kotlin.outputs.DscConfigurationParameterResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.automation.kotlin.outputs.ContentSourceResponse.Companion.toKotlin as contentSourceResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.DscConfigurationParameterResponse.Companion.toKotlin as dscConfigurationParameterResponseToKotlin

/**
 * Builder for [DscConfiguration].
 */
@PulumiTagMarker
public class DscConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DscConfigurationArgs = DscConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DscConfigurationArgsBuilder.() -> Unit) {
        val builder = DscConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DscConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.automation.DscConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DscConfiguration(builtJavaResource)
    }
}

/**
 * Definition of the configuration type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or Update Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscConfiguration = new AzureNative.Automation.DscConfiguration("dscConfiguration", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount18",
 *         ConfigurationName = "SetupServer",
 *         Description = "sample configuration",
 *         Location = "East US 2",
 *         Name = "SetupServer",
 *         ResourceGroupName = "rg",
 *         Source = new AzureNative.Automation.Inputs.ContentSourceArgs
 *         {
 *             Hash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha256",
 *                 Value = "A9E5DB56BA21513F61E0B3868816FDC6D4DF5131F5617D7FF0D769674BD5072F",
 *             },
 *             Type = AzureNative.Automation.ContentSourceType.EmbeddedContent,
 *             Value = @"Configuration SetupServer {
 *     Node localhost {
 *                                WindowsFeature IIS {
 *                                Name = ""Web-Server"";
 *             Ensure = ""Present""
 *         }
 *     }
 * }",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewDscConfiguration(ctx, "dscConfiguration", &automation.DscConfigurationArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount18"),
 * 			ConfigurationName:     pulumi.String("SetupServer"),
 * 			Description:           pulumi.String("sample configuration"),
 * 			Location:              pulumi.String("East US 2"),
 * 			Name:                  pulumi.String("SetupServer"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Source: &automation.ContentSourceArgs{
 * 				Hash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha256"),
 * 					Value:     pulumi.String("A9E5DB56BA21513F61E0B3868816FDC6D4DF5131F5617D7FF0D769674BD5072F"),
 * 				},
 * 				Type: pulumi.String(automation.ContentSourceTypeEmbeddedContent),
 * 				Value: pulumi.String(`Configuration SetupServer {
 *     Node localhost {
 *                                WindowsFeature IIS {
 *                                Name = "Web-Server";
 *             Ensure = "Present"
 *         }
 *     }
 * }`),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.DscConfiguration;
 * import com.pulumi.azurenative.automation.DscConfigurationArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentSourceArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscConfiguration = new DscConfiguration("dscConfiguration", DscConfigurationArgs.builder()
 *             .automationAccountName("myAutomationAccount18")
 *             .configurationName("SetupServer")
 *             .description("sample configuration")
 *             .location("East US 2")
 *             .name("SetupServer")
 *             .resourceGroupName("rg")
 *             .source(ContentSourceArgs.builder()
 *                 .hash(ContentHashArgs.builder()
 *                     .algorithm("sha256")
 *                     .value("A9E5DB56BA21513F61E0B3868816FDC6D4DF5131F5617D7FF0D769674BD5072F")
 *                     .build())
 *                 .type("embeddedContent")
 *                 .value("""
 * Configuration SetupServer {
 *     Node localhost {
 *                                WindowsFeature IIS {
 *                                Name = "Web-Server";
 *             Ensure = "Present"
 *         }
 *     }
 * }                """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:DscConfiguration SetupServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}
 * ```
 */
public class DscConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.DscConfiguration,
) : KotlinCustomResource(javaResource, DscConfigurationMapper) {
    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the etag of the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the job count of the configuration.
     */
    public val jobCount: Output<Int>?
        get() = javaResource.jobCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets verbose log option.
     */
    public val logVerbose: Output<Boolean>?
        get() = javaResource.logVerbose().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the number of compiled node configurations.
     */
    public val nodeConfigurationCount: Output<Int>?
        get() = javaResource.nodeConfigurationCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the configuration parameters.
     */
    public val parameters: Output<Map<String, DscConfigurationParameterResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            dscConfigurationParameterResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the provisioning state of the configuration.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the source.
     */
    public val source: Output<ContentSourceResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    contentSourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the state of the configuration.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DscConfigurationMapper : ResourceMapper<DscConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.DscConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DscConfiguration = DscConfiguration(
        javaResource as
            com.pulumi.azurenative.automation.DscConfiguration,
    )
}

/**
 * @see [DscConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DscConfiguration].
 */
public suspend fun dscConfiguration(
    name: String,
    block: suspend DscConfigurationResourceBuilder.() -> Unit,
): DscConfiguration {
    val builder = DscConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DscConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dscConfiguration(name: String): DscConfiguration {
    val builder = DscConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
