@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.DscConfigurationArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentSourceArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentSourceArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.DscConfigurationParameterArgs
import com.pulumi.azurenative.automation.kotlin.inputs.DscConfigurationParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the configuration type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or Update Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscConfiguration = new AzureNative.Automation.DscConfiguration("dscConfiguration", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount18",
 *         ConfigurationName = "SetupServer",
 *         Description = "sample configuration",
 *         Location = "East US 2",
 *         Name = "SetupServer",
 *         ResourceGroupName = "rg",
 *         Source = new AzureNative.Automation.Inputs.ContentSourceArgs
 *         {
 *             Hash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha256",
 *                 Value = "A9E5DB56BA21513F61E0B3868816FDC6D4DF5131F5617D7FF0D769674BD5072F",
 *             },
 *             Type = AzureNative.Automation.ContentSourceType.EmbeddedContent,
 *             Value = @"Configuration SetupServer {
 *     Node localhost {
 *                                WindowsFeature IIS {
 *                                Name = ""Web-Server"";
 *             Ensure = ""Present""
 *         }
 *     }
 * }",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewDscConfiguration(ctx, "dscConfiguration", &automation.DscConfigurationArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount18"),
 * 			ConfigurationName:     pulumi.String("SetupServer"),
 * 			Description:           pulumi.String("sample configuration"),
 * 			Location:              pulumi.String("East US 2"),
 * 			Name:                  pulumi.String("SetupServer"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Source: &automation.ContentSourceArgs{
 * 				Hash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha256"),
 * 					Value:     pulumi.String("A9E5DB56BA21513F61E0B3868816FDC6D4DF5131F5617D7FF0D769674BD5072F"),
 * 				},
 * 				Type: pulumi.String(automation.ContentSourceTypeEmbeddedContent),
 * 				Value: pulumi.String(`Configuration SetupServer {
 *     Node localhost {
 *                                WindowsFeature IIS {
 *                                Name = "Web-Server";
 *             Ensure = "Present"
 *         }
 *     }
 * }`),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.DscConfiguration;
 * import com.pulumi.azurenative.automation.DscConfigurationArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentSourceArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscConfiguration = new DscConfiguration("dscConfiguration", DscConfigurationArgs.builder()
 *             .automationAccountName("myAutomationAccount18")
 *             .configurationName("SetupServer")
 *             .description("sample configuration")
 *             .location("East US 2")
 *             .name("SetupServer")
 *             .resourceGroupName("rg")
 *             .source(ContentSourceArgs.builder()
 *                 .hash(ContentHashArgs.builder()
 *                     .algorithm("sha256")
 *                     .value("A9E5DB56BA21513F61E0B3868816FDC6D4DF5131F5617D7FF0D769674BD5072F")
 *                     .build())
 *                 .type("embeddedContent")
 *                 .value("""
 * Configuration SetupServer {
 *     Node localhost {
 *                                WindowsFeature IIS {
 *                                Name = "Web-Server";
 *             Ensure = "Present"
 *         }
 *     }
 * }                """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:DscConfiguration SetupServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property configurationName The create or update parameters for configuration.
 * @property description Gets or sets the description of the configuration.
 * @property location Gets or sets the location of the resource.
 * @property logProgress Gets or sets progress log option.
 * @property logVerbose Gets or sets verbose log option.
 * @property name Gets or sets name of the resource.
 * @property parameters Gets or sets the configuration parameters.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property source Gets or sets the source.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class DscConfigurationArgs(
    public val automationAccountName: Output<String>? = null,
    public val configurationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val logProgress: Output<Boolean>? = null,
    public val logVerbose: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, DscConfigurationParameterArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<ContentSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.DscConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.DscConfigurationArgs =
        com.pulumi.azurenative.automation.DscConfigurationArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logProgress(logProgress?.applyValue({ args0 -> args0 }))
            .logVerbose(logVerbose?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DscConfigurationArgs].
 */
@PulumiTagMarker
public class DscConfigurationArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var configurationName: Output<String>? = null

    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var logProgress: Output<Boolean>? = null

    private var logVerbose: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, DscConfigurationParameterArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<ContentSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("oqjwigqkcrcfnmqr")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The create or update parameters for configuration.
     */
    @JvmName("mtmcqhbxhmomacug")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Gets or sets the description of the configuration.
     */
    @JvmName("fjeplqvchrmqjhqe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("ssebrpqofbeuqosa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets progress log option.
     */
    @JvmName("bubakumpabtbkhwh")
    public suspend fun logProgress(`value`: Output<Boolean>) {
        this.logProgress = value
    }

    /**
     * @param value Gets or sets verbose log option.
     */
    @JvmName("utdecfmfehhkrkea")
    public suspend fun logVerbose(`value`: Output<Boolean>) {
        this.logVerbose = value
    }

    /**
     * @param value Gets or sets name of the resource.
     */
    @JvmName("ralfpkxufufljqxl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the configuration parameters.
     */
    @JvmName("ygvbyrfjivqwtstr")
    public suspend fun parameters(`value`: Output<Map<String, DscConfigurationParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ockqludmmgpbkulv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the source.
     */
    @JvmName("bmsfhtgauhrlaxve")
    public suspend fun source(`value`: Output<ContentSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("wwxcphwducqovqhf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ocadanjwrrscsdrm")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The create or update parameters for configuration.
     */
    @JvmName("wptvbjiftewqwdgg")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Gets or sets the description of the configuration.
     */
    @JvmName("kjlptjmyielahmji")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("kdjwqsrkrruvrntk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets progress log option.
     */
    @JvmName("puwprtvexuheucbh")
    public suspend fun logProgress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logProgress = mapped
    }

    /**
     * @param value Gets or sets verbose log option.
     */
    @JvmName("kymbnxoavwtpdigh")
    public suspend fun logVerbose(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbose = mapped
    }

    /**
     * @param value Gets or sets name of the resource.
     */
    @JvmName("kehmtklbfkamluxq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the configuration parameters.
     */
    @JvmName("yeepwadcubfkfnfh")
    public suspend fun parameters(`value`: Map<String, DscConfigurationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Gets or sets the configuration parameters.
     */
    @JvmName("qvmdeppmbnqxabmx")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend DscConfigurationParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                DscConfigurationParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Gets or sets the configuration parameters.
     */
    @JvmName("kvpcvbhdcrddkutv")
    public fun parameters(vararg values: Pair<String, DscConfigurationParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("xqvmvkekhxbgpotv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the source.
     */
    @JvmName("psjwqjhtstndmngr")
    public suspend fun source(`value`: ContentSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Gets or sets the source.
     */
    @JvmName("qibqkwtpfsgqgwlo")
    public suspend fun source(argument: suspend ContentSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ContentSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("uruqfvjrflqyppus")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("dttjlyjtgyqyubcd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DscConfigurationArgs = DscConfigurationArgs(
        automationAccountName = automationAccountName,
        configurationName = configurationName,
        description = description,
        location = location,
        logProgress = logProgress,
        logVerbose = logVerbose,
        name = name,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        source = source,
        tags = tags,
    )
}
