@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HybridRunbookWorker].
 */
@PulumiTagMarker
public class HybridRunbookWorkerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridRunbookWorkerArgs = HybridRunbookWorkerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridRunbookWorkerArgsBuilder.() -> Unit) {
        val builder = HybridRunbookWorkerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HybridRunbookWorker {
        val builtJavaResource =
            com.pulumi.azurenative.automation.HybridRunbookWorker(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HybridRunbookWorker(builtJavaResource)
    }
}

/**
 * Definition of hybrid runbook worker.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2021-06-22.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a V2 hybrid runbook worker
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridRunbookWorker = new AzureNative.Automation.HybridRunbookWorker("hybridRunbookWorker", new()
 *     {
 *         AutomationAccountName = "testaccount",
 *         HybridRunbookWorkerGroupName = "TestHybridGroup",
 *         HybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd",
 *         ResourceGroupName = "rg",
 *         VmResourceId = "/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewHybridRunbookWorker(ctx, "hybridRunbookWorker", &automation.HybridRunbookWorkerArgs{
 * 			AutomationAccountName:        pulumi.String("testaccount"),
 * 			HybridRunbookWorkerGroupName: pulumi.String("TestHybridGroup"),
 * 			HybridRunbookWorkerId:        pulumi.String("c010ad12-ef14-4a2a-aa9e-ef22c4745ddd"),
 * 			ResourceGroupName:            pulumi.String("rg"),
 * 			VmResourceId:                 pulumi.String("/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.HybridRunbookWorker;
 * import com.pulumi.azurenative.automation.HybridRunbookWorkerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridRunbookWorker = new HybridRunbookWorker("hybridRunbookWorker", HybridRunbookWorkerArgs.builder()
 *             .automationAccountName("testaccount")
 *             .hybridRunbookWorkerGroupName("TestHybridGroup")
 *             .hybridRunbookWorkerId("c010ad12-ef14-4a2a-aa9e-ef22c4745ddd")
 *             .resourceGroupName("rg")
 *             .vmResourceId("/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:HybridRunbookWorker c010ad12-ef14-4a2a-aa9e-ef22c4745ddd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers/{hybridRunbookWorkerId}
 * ```
 */
public class HybridRunbookWorker internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.HybridRunbookWorker,
) : KotlinCustomResource(javaResource, HybridRunbookWorkerMapper) {
    /**
     * Gets or sets the assigned machine IP address.
     */
    public val ip: Output<String>?
        get() = javaResource.ip().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Last Heartbeat from the Worker
     */
    public val lastSeenDateTime: Output<String>?
        get() = javaResource.lastSeenDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the registration time of the worker machine.
     */
    public val registeredDateTime: Output<String>?
        get() = javaResource.registeredDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource system metadata.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager Id for a virtual machine.
     */
    public val vmResourceId: Output<String>?
        get() = javaResource.vmResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the HybridWorker.
     */
    public val workerName: Output<String>?
        get() = javaResource.workerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the HybridWorker.
     */
    public val workerType: Output<String>?
        get() = javaResource.workerType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object HybridRunbookWorkerMapper : ResourceMapper<HybridRunbookWorker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.HybridRunbookWorker::class == javaResource::class

    override fun map(javaResource: Resource): HybridRunbookWorker = HybridRunbookWorker(
        javaResource
            as com.pulumi.azurenative.automation.HybridRunbookWorker,
    )
}

/**
 * @see [HybridRunbookWorker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridRunbookWorker].
 */
public suspend fun hybridRunbookWorker(
    name: String,
    block: suspend HybridRunbookWorkerResourceBuilder.() -> Unit,
): HybridRunbookWorker {
    val builder = HybridRunbookWorkerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridRunbookWorker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridRunbookWorker(name: String): HybridRunbookWorker {
    val builder = HybridRunbookWorkerResourceBuilder()
    builder.name(name)
    return builder.build()
}
