@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.Python2PackageArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the module type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a python 2 package
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var python2Package = new AzureNative.Automation.Python2Package("python2Package", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *             Version = "1.0.0.0",
 *         },
 *         PackageName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewPython2Package(ctx, "python2Package", &automation.Python2PackageArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: &automation.ContentLinkArgs{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A"),
 * 				},
 * 				Uri:     pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 				Version: pulumi.String("1.0.0.0"),
 * 			},
 * 			PackageName:       pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Python2Package;
 * import com.pulumi.azurenative.automation.Python2PackageArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentLinkArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var python2Package = new Python2Package("python2Package", Python2PackageArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(ContentLinkArgs.builder()
 *                 .contentHash(ContentHashArgs.builder()
 *                     .algorithm("sha265")
 *                     .value("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A")
 *                     .build())
 *                 .uri("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip")
 *                 .version("1.0.0.0")
 *                 .build())
 *             .packageName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Python2Package OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/python2Packages/{packageName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property contentLink Gets or sets the module content link.
 * @property packageName The name of python package.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class Python2PackageArgs(
    public val automationAccountName: Output<String>? = null,
    public val contentLink: Output<ContentLinkArgs>? = null,
    public val packageName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.Python2PackageArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.Python2PackageArgs =
        com.pulumi.azurenative.automation.Python2PackageArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .contentLink(contentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [Python2PackageArgs].
 */
@PulumiTagMarker
public class Python2PackageArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var contentLink: Output<ContentLinkArgs>? = null

    private var packageName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("defgcqtglybvlfwe")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the module content link.
     */
    @JvmName("kdmjjnydqbtfgdvh")
    public suspend fun contentLink(`value`: Output<ContentLinkArgs>) {
        this.contentLink = value
    }

    /**
     * @param value The name of python package.
     */
    @JvmName("tyyoqsnuwarmemnd")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("eniqymftxneconku")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("lxgdbpfqxsnggxku")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("rxipulnaptqnkcxk")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the module content link.
     */
    @JvmName("wrltdsexjlypsaje")
    public suspend fun contentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLink = mapped
    }

    /**
     * @param argument Gets or sets the module content link.
     */
    @JvmName("cgkurvhycuyvmysv")
    public suspend fun contentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLink = mapped
    }

    /**
     * @param value The name of python package.
     */
    @JvmName("rfweqbyhbclcofbf")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("hfbfsiyjjnavckmp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("uqiwvtfxirwjjale")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("buresubkyjbisbtg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): Python2PackageArgs = Python2PackageArgs(
        automationAccountName = automationAccountName,
        contentLink = contentLink,
        packageName = packageName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
