@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.RunbookArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.RunbookTypeEnum
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.RunbookDraftArgs
import com.pulumi.azurenative.automation.kotlin.inputs.RunbookDraftArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the runbook type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update runbook and publish it
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var runbook = new AzureNative.Automation.Runbook("runbook", new()
 *     {
 *         AutomationAccountName = "ContoseAutomationAccount",
 *         Description = "Description of the Runbook",
 *         Location = "East US 2",
 *         LogActivityTrace = 1,
 *         LogProgress = true,
 *         LogVerbose = false,
 *         Name = "Get-AzureVMTutorial",
 *         PublishContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "SHA256",
 *                 Value = "115775B8FF2BE672D8A946BD0B489918C724DDE15A440373CA54461D53010A80",
 *             },
 *             Uri = "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1",
 *         },
 *         ResourceGroupName = "rg",
 *         RunbookName = "Get-AzureVMTutorial",
 *         RunbookType = AzureNative.Automation.RunbookTypeEnum.PowerShellWorkflow,
 *         Tags =
 *         {
 *             { "tag01", "value01" },
 *             { "tag02", "value02" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewRunbook(ctx, "runbook", &automation.RunbookArgs{
 * 			AutomationAccountName: pulumi.String("ContoseAutomationAccount"),
 * 			Description:           pulumi.String("Description of the Runbook"),
 * 			Location:              pulumi.String("East US 2"),
 * 			LogActivityTrace:      pulumi.Int(1),
 * 			LogProgress:           pulumi.Bool(true),
 * 			LogVerbose:            pulumi.Bool(false),
 * 			Name:                  pulumi.String("Get-AzureVMTutorial"),
 * 			PublishContentLink: &automation.ContentLinkArgs{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("SHA256"),
 * 					Value:     pulumi.String("115775B8FF2BE672D8A946BD0B489918C724DDE15A440373CA54461D53010A80"),
 * 				},
 * 				Uri: pulumi.String("https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			RunbookName:       pulumi.String("Get-AzureVMTutorial"),
 * 			RunbookType:       pulumi.String(automation.RunbookTypeEnumPowerShellWorkflow),
 * 			Tags: pulumi.StringMap{
 * 				"tag01": pulumi.String("value01"),
 * 				"tag02": pulumi.String("value02"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Runbook;
 * import com.pulumi.azurenative.automation.RunbookArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentLinkArgs;
 * import com.pulumi.azurenative.automation.inputs.ContentHashArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var runbook = new Runbook("runbook", RunbookArgs.builder()
 *             .automationAccountName("ContoseAutomationAccount")
 *             .description("Description of the Runbook")
 *             .location("East US 2")
 *             .logActivityTrace(1)
 *             .logProgress(true)
 *             .logVerbose(false)
 *             .name("Get-AzureVMTutorial")
 *             .publishContentLink(ContentLinkArgs.builder()
 *                 .contentHash(ContentHashArgs.builder()
 *                     .algorithm("SHA256")
 *                     .value("115775B8FF2BE672D8A946BD0B489918C724DDE15A440373CA54461D53010A80")
 *                     .build())
 *                 .uri("https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1")
 *                 .build())
 *             .resourceGroupName("rg")
 *             .runbookName("Get-AzureVMTutorial")
 *             .runbookType("PowerShellWorkflow")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag01", "value01"),
 *                 Map.entry("tag02", "value02")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create runbook as draft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var runbook = new AzureNative.Automation.Runbook("runbook", new()
 *     {
 *         AutomationAccountName = "ContoseAutomationAccount",
 *         Description = "Description of the Runbook",
 *         Draft = null,
 *         Location = "East US 2",
 *         LogProgress = false,
 *         LogVerbose = false,
 *         Name = "Get-AzureVMTutorial",
 *         ResourceGroupName = "rg",
 *         RunbookName = "Get-AzureVMTutorial",
 *         RunbookType = AzureNative.Automation.RunbookTypeEnum.PowerShellWorkflow,
 *         Tags =
 *         {
 *             { "tag01", "value01" },
 *             { "tag02", "value02" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewRunbook(ctx, "runbook", &automation.RunbookArgs{
 * 			AutomationAccountName: pulumi.String("ContoseAutomationAccount"),
 * 			Description:           pulumi.String("Description of the Runbook"),
 * 			Draft:                 nil,
 * 			Location:              pulumi.String("East US 2"),
 * 			LogProgress:           pulumi.Bool(false),
 * 			LogVerbose:            pulumi.Bool(false),
 * 			Name:                  pulumi.String("Get-AzureVMTutorial"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			RunbookName:           pulumi.String("Get-AzureVMTutorial"),
 * 			RunbookType:           pulumi.String(automation.RunbookTypeEnumPowerShellWorkflow),
 * 			Tags: pulumi.StringMap{
 * 				"tag01": pulumi.String("value01"),
 * 				"tag02": pulumi.String("value02"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Runbook;
 * import com.pulumi.azurenative.automation.RunbookArgs;
 * import com.pulumi.azurenative.automation.inputs.RunbookDraftArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var runbook = new Runbook("runbook", RunbookArgs.builder()
 *             .automationAccountName("ContoseAutomationAccount")
 *             .description("Description of the Runbook")
 *             .draft()
 *             .location("East US 2")
 *             .logProgress(false)
 *             .logVerbose(false)
 *             .name("Get-AzureVMTutorial")
 *             .resourceGroupName("rg")
 *             .runbookName("Get-AzureVMTutorial")
 *             .runbookType("PowerShellWorkflow")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag01", "value01"),
 *                 Map.entry("tag02", "value02")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Runbook Get-AzureVMTutorial /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property description Gets or sets the description of the runbook.
 * @property draft Gets or sets the draft runbook properties.
 * @property location Gets or sets the location of the resource.
 * @property logActivityTrace Gets or sets the activity-level tracing options of the runbook.
 * @property logProgress Gets or sets progress log option.
 * @property logVerbose Gets or sets verbose log option.
 * @property name Gets or sets the name of the resource.
 * @property publishContentLink Gets or sets the published runbook content link.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runbookName The runbook name.
 * @property runbookType Gets or sets the type of the runbook.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class RunbookArgs(
    public val automationAccountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val draft: Output<RunbookDraftArgs>? = null,
    public val location: Output<String>? = null,
    public val logActivityTrace: Output<Int>? = null,
    public val logProgress: Output<Boolean>? = null,
    public val logVerbose: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val publishContentLink: Output<ContentLinkArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runbookName: Output<String>? = null,
    public val runbookType: Output<Either<String, RunbookTypeEnum>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.RunbookArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.RunbookArgs =
        com.pulumi.azurenative.automation.RunbookArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .draft(draft?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logActivityTrace(logActivityTrace?.applyValue({ args0 -> args0 }))
            .logProgress(logProgress?.applyValue({ args0 -> args0 }))
            .logVerbose(logVerbose?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publishContentLink(
                publishContentLink?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runbookName(runbookName?.applyValue({ args0 -> args0 }))
            .runbookType(
                runbookType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RunbookArgs].
 */
@PulumiTagMarker
public class RunbookArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var description: Output<String>? = null

    private var draft: Output<RunbookDraftArgs>? = null

    private var location: Output<String>? = null

    private var logActivityTrace: Output<Int>? = null

    private var logProgress: Output<Boolean>? = null

    private var logVerbose: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var publishContentLink: Output<ContentLinkArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var runbookName: Output<String>? = null

    private var runbookType: Output<Either<String, RunbookTypeEnum>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("tglbpiqytvoedhee")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the description of the runbook.
     */
    @JvmName("cpsocpianeijvgcb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the draft runbook properties.
     */
    @JvmName("axmmmowbmfrvaipm")
    public suspend fun draft(`value`: Output<RunbookDraftArgs>) {
        this.draft = value
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("aumwmqnvtfoxtugg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the activity-level tracing options of the runbook.
     */
    @JvmName("ukukqendfvpwxumn")
    public suspend fun logActivityTrace(`value`: Output<Int>) {
        this.logActivityTrace = value
    }

    /**
     * @param value Gets or sets progress log option.
     */
    @JvmName("udjcmveqvfaetjvw")
    public suspend fun logProgress(`value`: Output<Boolean>) {
        this.logProgress = value
    }

    /**
     * @param value Gets or sets verbose log option.
     */
    @JvmName("vqlummuxjkuppvtg")
    public suspend fun logVerbose(`value`: Output<Boolean>) {
        this.logVerbose = value
    }

    /**
     * @param value Gets or sets the name of the resource.
     */
    @JvmName("yorndmvjnjufnsab")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the published runbook content link.
     */
    @JvmName("ijbwbvbogiiwomjl")
    public suspend fun publishContentLink(`value`: Output<ContentLinkArgs>) {
        this.publishContentLink = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("lbeyllmkufuxunpy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The runbook name.
     */
    @JvmName("nmytukawjuwrpcyp")
    public suspend fun runbookName(`value`: Output<String>) {
        this.runbookName = value
    }

    /**
     * @param value Gets or sets the type of the runbook.
     */
    @JvmName("ilisyddqaaokpttl")
    public suspend fun runbookType(`value`: Output<Either<String, RunbookTypeEnum>>) {
        this.runbookType = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("wylxmfvvfnlmavle")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ysfuojeieltnkjnq")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the description of the runbook.
     */
    @JvmName("yulbcrkudlthfund")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the draft runbook properties.
     */
    @JvmName("wkfcheydttefymgf")
    public suspend fun draft(`value`: RunbookDraftArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.draft = mapped
    }

    /**
     * @param argument Gets or sets the draft runbook properties.
     */
    @JvmName("qauynusptiwuityp")
    public suspend fun draft(argument: suspend RunbookDraftArgsBuilder.() -> Unit) {
        val toBeMapped = RunbookDraftArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.draft = mapped
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("jlmhqtnpeomeocud")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the activity-level tracing options of the runbook.
     */
    @JvmName("rtfyydmpachmpoat")
    public suspend fun logActivityTrace(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logActivityTrace = mapped
    }

    /**
     * @param value Gets or sets progress log option.
     */
    @JvmName("ilsghllgpfqduspr")
    public suspend fun logProgress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logProgress = mapped
    }

    /**
     * @param value Gets or sets verbose log option.
     */
    @JvmName("uidlirollphbwkgl")
    public suspend fun logVerbose(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbose = mapped
    }

    /**
     * @param value Gets or sets the name of the resource.
     */
    @JvmName("cryvfnhljpheyalu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the published runbook content link.
     */
    @JvmName("dyyaagtuvfeeukct")
    public suspend fun publishContentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishContentLink = mapped
    }

    /**
     * @param argument Gets or sets the published runbook content link.
     */
    @JvmName("qfsmcxudkwdpbiif")
    public suspend fun publishContentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publishContentLink = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ubginkvxtqvywuxh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The runbook name.
     */
    @JvmName("wcqppeujkqglfiui")
    public suspend fun runbookName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runbookName = mapped
    }

    /**
     * @param value Gets or sets the type of the runbook.
     */
    @JvmName("gtmhwktiqcvsmbqo")
    public suspend fun runbookType(`value`: Either<String, RunbookTypeEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runbookType = mapped
    }

    /**
     * @param value Gets or sets the type of the runbook.
     */
    @JvmName("prwkciucrahjmtnv")
    public fun runbookType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RunbookTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runbookType = mapped
    }

    /**
     * @param value Gets or sets the type of the runbook.
     */
    @JvmName("snmhdwbtrsvtuhot")
    public fun runbookType(`value`: RunbookTypeEnum) {
        val toBeMapped = Either.ofRight<String, RunbookTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runbookType = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("sydoqgwpkbcvxqml")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("ljdcqnsaagsxqjek")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RunbookArgs = RunbookArgs(
        automationAccountName = automationAccountName,
        description = description,
        draft = draft,
        location = location,
        logActivityTrace = logActivityTrace,
        logProgress = logProgress,
        logVerbose = logVerbose,
        name = name,
        publishContentLink = publishContentLink,
        resourceGroupName = resourceGroupName,
        runbookName = runbookName,
        runbookType = runbookType,
        tags = tags,
    )
}
