@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SourceControl].
 */
@PulumiTagMarker
public class SourceControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SourceControlArgs = SourceControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SourceControlArgsBuilder.() -> Unit) {
        val builder = SourceControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SourceControl {
        val builtJavaResource = com.pulumi.azurenative.automation.SourceControl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SourceControl(builtJavaResource)
    }
}

/**
 * Definition of the source control.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a source control
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sourceControl = new AzureNative.Automation.SourceControl("sourceControl", new()
 *     {
 *         AutoSync = true,
 *         AutomationAccountName = "sampleAccount9",
 *         Branch = "master",
 *         Description = "my description",
 *         FolderPath = "/folderOne/folderTwo",
 *         PublishRunbook = true,
 *         RepoUrl = "https://sampleUser.visualstudio.com/myProject/_git/myRepository",
 *         ResourceGroupName = "rg",
 *         SecurityToken = new AzureNative.Automation.Inputs.SourceControlSecurityTokenPropertiesArgs
 *         {
 *             AccessToken = "******",
 *             TokenType = AzureNative.Automation.TokenType.PersonalAccessToken,
 *         },
 *         SourceControlName = "sampleSourceControl",
 *         SourceType = AzureNative.Automation.SourceType.VsoGit,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewSourceControl(ctx, "sourceControl", &automation.SourceControlArgs{
 * 			AutoSync:              pulumi.Bool(true),
 * 			AutomationAccountName: pulumi.String("sampleAccount9"),
 * 			Branch:                pulumi.String("master"),
 * 			Description:           pulumi.String("my description"),
 * 			FolderPath:            pulumi.String("/folderOne/folderTwo"),
 * 			PublishRunbook:        pulumi.Bool(true),
 * 			RepoUrl:               pulumi.String("https://sampleUser.visualstudio.com/myProject/_git/myRepository"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			SecurityToken: &automation.SourceControlSecurityTokenPropertiesArgs{
 * 				AccessToken: pulumi.String("******"),
 * 				TokenType:   pulumi.String(automation.TokenTypePersonalAccessToken),
 * 			},
 * 			SourceControlName: pulumi.String("sampleSourceControl"),
 * 			SourceType:        pulumi.String(automation.SourceTypeVsoGit),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.SourceControl;
 * import com.pulumi.azurenative.automation.SourceControlArgs;
 * import com.pulumi.azurenative.automation.inputs.SourceControlSecurityTokenPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sourceControl = new SourceControl("sourceControl", SourceControlArgs.builder()
 *             .autoSync(true)
 *             .automationAccountName("sampleAccount9")
 *             .branch("master")
 *             .description("my description")
 *             .folderPath("/folderOne/folderTwo")
 *             .publishRunbook(true)
 *             .repoUrl("https://sampleUser.visualstudio.com/myProject/_git/myRepository")
 *             .resourceGroupName("rg")
 *             .securityToken(SourceControlSecurityTokenPropertiesArgs.builder()
 *                 .accessToken("******")
 *                 .tokenType("PersonalAccessToken")
 *                 .build())
 *             .sourceControlName("sampleSourceControl")
 *             .sourceType("VsoGit")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:SourceControl sampleSourceControl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}
 * ```
 */
public class SourceControl internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.SourceControl,
) : KotlinCustomResource(javaResource, SourceControlMapper) {
    /**
     * The auto sync of the source control. Default is false.
     */
    public val autoSync: Output<Boolean>?
        get() = javaResource.autoSync().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The repo branch of the source control. Include branch as empty string for VsoTfvc.
     */
    public val branch: Output<String>?
        get() = javaResource.branch().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The folder path of the source control.
     */
    public val folderPath: Output<String>?
        get() = javaResource.folderPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The auto publish of the source control. Default is true.
     */
    public val publishRunbook: Output<Boolean>?
        get() = javaResource.publishRunbook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The repo url of the source control.
     */
    public val repoUrl: Output<String>?
        get() = javaResource.repoUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The source type. Must be one of VsoGit, VsoTfvc, GitHub.
     */
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SourceControlMapper : ResourceMapper<SourceControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.SourceControl::class == javaResource::class

    override fun map(javaResource: Resource): SourceControl = SourceControl(
        javaResource as
            com.pulumi.azurenative.automation.SourceControl,
    )
}

/**
 * @see [SourceControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SourceControl].
 */
public suspend fun sourceControl(
    name: String,
    block: suspend SourceControlResourceBuilder.() -> Unit,
): SourceControl {
    val builder = SourceControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SourceControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sourceControl(name: String): SourceControl {
    val builder = SourceControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
