@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.SourceControlArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.SourceType
import com.pulumi.azurenative.automation.kotlin.inputs.SourceControlSecurityTokenPropertiesArgs
import com.pulumi.azurenative.automation.kotlin.inputs.SourceControlSecurityTokenPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the source control.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a source control
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sourceControl = new AzureNative.Automation.SourceControl("sourceControl", new()
 *     {
 *         AutoSync = true,
 *         AutomationAccountName = "sampleAccount9",
 *         Branch = "master",
 *         Description = "my description",
 *         FolderPath = "/folderOne/folderTwo",
 *         PublishRunbook = true,
 *         RepoUrl = "https://sampleUser.visualstudio.com/myProject/_git/myRepository",
 *         ResourceGroupName = "rg",
 *         SecurityToken = new AzureNative.Automation.Inputs.SourceControlSecurityTokenPropertiesArgs
 *         {
 *             AccessToken = "******",
 *             TokenType = AzureNative.Automation.TokenType.PersonalAccessToken,
 *         },
 *         SourceControlName = "sampleSourceControl",
 *         SourceType = AzureNative.Automation.SourceType.VsoGit,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewSourceControl(ctx, "sourceControl", &automation.SourceControlArgs{
 * 			AutoSync:              pulumi.Bool(true),
 * 			AutomationAccountName: pulumi.String("sampleAccount9"),
 * 			Branch:                pulumi.String("master"),
 * 			Description:           pulumi.String("my description"),
 * 			FolderPath:            pulumi.String("/folderOne/folderTwo"),
 * 			PublishRunbook:        pulumi.Bool(true),
 * 			RepoUrl:               pulumi.String("https://sampleUser.visualstudio.com/myProject/_git/myRepository"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			SecurityToken: &automation.SourceControlSecurityTokenPropertiesArgs{
 * 				AccessToken: pulumi.String("******"),
 * 				TokenType:   pulumi.String(automation.TokenTypePersonalAccessToken),
 * 			},
 * 			SourceControlName: pulumi.String("sampleSourceControl"),
 * 			SourceType:        pulumi.String(automation.SourceTypeVsoGit),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.SourceControl;
 * import com.pulumi.azurenative.automation.SourceControlArgs;
 * import com.pulumi.azurenative.automation.inputs.SourceControlSecurityTokenPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sourceControl = new SourceControl("sourceControl", SourceControlArgs.builder()
 *             .autoSync(true)
 *             .automationAccountName("sampleAccount9")
 *             .branch("master")
 *             .description("my description")
 *             .folderPath("/folderOne/folderTwo")
 *             .publishRunbook(true)
 *             .repoUrl("https://sampleUser.visualstudio.com/myProject/_git/myRepository")
 *             .resourceGroupName("rg")
 *             .securityToken(SourceControlSecurityTokenPropertiesArgs.builder()
 *                 .accessToken("******")
 *                 .tokenType("PersonalAccessToken")
 *                 .build())
 *             .sourceControlName("sampleSourceControl")
 *             .sourceType("VsoGit")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:SourceControl sampleSourceControl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}
 * ```
 * @property autoSync The auto async of the source control. Default is false.
 * @property automationAccountName The name of the automation account.
 * @property branch The repo branch of the source control. Include branch as empty string for VsoTfvc.
 * @property description The user description of the source control.
 * @property folderPath The folder path of the source control. Path must be relative.
 * @property publishRunbook The auto publish of the source control. Default is true.
 * @property repoUrl The repo url of the source control.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property securityToken The authorization token for the repo of the source control.
 * @property sourceControlName The source control name.
 * @property sourceType The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
 */
public data class SourceControlArgs(
    public val autoSync: Output<Boolean>? = null,
    public val automationAccountName: Output<String>? = null,
    public val branch: Output<String>? = null,
    public val description: Output<String>? = null,
    public val folderPath: Output<String>? = null,
    public val publishRunbook: Output<Boolean>? = null,
    public val repoUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityToken: Output<SourceControlSecurityTokenPropertiesArgs>? = null,
    public val sourceControlName: Output<String>? = null,
    public val sourceType: Output<Either<String, SourceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.SourceControlArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.SourceControlArgs =
        com.pulumi.azurenative.automation.SourceControlArgs.builder()
            .autoSync(autoSync?.applyValue({ args0 -> args0 }))
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .branch(branch?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .publishRunbook(publishRunbook?.applyValue({ args0 -> args0 }))
            .repoUrl(repoUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityToken(securityToken?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceControlName(sourceControlName?.applyValue({ args0 -> args0 }))
            .sourceType(
                sourceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SourceControlArgs].
 */
@PulumiTagMarker
public class SourceControlArgsBuilder internal constructor() {
    private var autoSync: Output<Boolean>? = null

    private var automationAccountName: Output<String>? = null

    private var branch: Output<String>? = null

    private var description: Output<String>? = null

    private var folderPath: Output<String>? = null

    private var publishRunbook: Output<Boolean>? = null

    private var repoUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityToken: Output<SourceControlSecurityTokenPropertiesArgs>? = null

    private var sourceControlName: Output<String>? = null

    private var sourceType: Output<Either<String, SourceType>>? = null

    /**
     * @param value The auto async of the source control. Default is false.
     */
    @JvmName("wdhpnvegnhhxymtc")
    public suspend fun autoSync(`value`: Output<Boolean>) {
        this.autoSync = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("awwhmogwgyokpscj")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The repo branch of the source control. Include branch as empty string for VsoTfvc.
     */
    @JvmName("iupiqbmsuaetmnyt")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value The user description of the source control.
     */
    @JvmName("qkglccfxmfagxjjd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder path of the source control. Path must be relative.
     */
    @JvmName("dmmtrqqwsdtiiyec")
    public suspend fun folderPath(`value`: Output<String>) {
        this.folderPath = value
    }

    /**
     * @param value The auto publish of the source control. Default is true.
     */
    @JvmName("dreyevnyxhetcuvc")
    public suspend fun publishRunbook(`value`: Output<Boolean>) {
        this.publishRunbook = value
    }

    /**
     * @param value The repo url of the source control.
     */
    @JvmName("jxktepkesonqwbwp")
    public suspend fun repoUrl(`value`: Output<String>) {
        this.repoUrl = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("oqvdywjxwfutscnr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The authorization token for the repo of the source control.
     */
    @JvmName("hvabkcgprwbxxfju")
    public suspend fun securityToken(`value`: Output<SourceControlSecurityTokenPropertiesArgs>) {
        this.securityToken = value
    }

    /**
     * @param value The source control name.
     */
    @JvmName("aauswopydsmxtves")
    public suspend fun sourceControlName(`value`: Output<String>) {
        this.sourceControlName = value
    }

    /**
     * @param value The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
     */
    @JvmName("snblerbiqpbbtcvc")
    public suspend fun sourceType(`value`: Output<Either<String, SourceType>>) {
        this.sourceType = value
    }

    /**
     * @param value The auto async of the source control. Default is false.
     */
    @JvmName("crpftseboifearhi")
    public suspend fun autoSync(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSync = mapped
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("lbtxrtyajuhsylly")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The repo branch of the source control. Include branch as empty string for VsoTfvc.
     */
    @JvmName("tdfeqahirvcxuavr")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value The user description of the source control.
     */
    @JvmName("ajnexqewagakuiut")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder path of the source control. Path must be relative.
     */
    @JvmName("yllhvlbxejiuuqqm")
    public suspend fun folderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value The auto publish of the source control. Default is true.
     */
    @JvmName("yqscgjcvwkkiykfi")
    public suspend fun publishRunbook(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishRunbook = mapped
    }

    /**
     * @param value The repo url of the source control.
     */
    @JvmName("pogxupscshalhgtx")
    public suspend fun repoUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoUrl = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("mtdxfikiwtvgncjb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The authorization token for the repo of the source control.
     */
    @JvmName("dmeyrbamuvhtukle")
    public suspend fun securityToken(`value`: SourceControlSecurityTokenPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityToken = mapped
    }

    /**
     * @param argument The authorization token for the repo of the source control.
     */
    @JvmName("pqfqakgpsnyytekm")
    public suspend
    fun securityToken(argument: suspend SourceControlSecurityTokenPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SourceControlSecurityTokenPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityToken = mapped
    }

    /**
     * @param value The source control name.
     */
    @JvmName("cfemajptqvinfbor")
    public suspend fun sourceControlName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceControlName = mapped
    }

    /**
     * @param value The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
     */
    @JvmName("jsjusaojejxrfnyn")
    public suspend fun sourceType(`value`: Either<String, SourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
     */
    @JvmName("rywgsjdsopjgccqh")
    public fun sourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
     */
    @JvmName("aekvwkmvgmexqjwy")
    public fun sourceType(`value`: SourceType) {
        val toBeMapped = Either.ofRight<String, SourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): SourceControlArgs = SourceControlArgs(
        autoSync = autoSync,
        automationAccountName = automationAccountName,
        branch = branch,
        description = description,
        folderPath = folderPath,
        publishRunbook = publishRunbook,
        repoUrl = repoUrl,
        resourceGroupName = resourceGroupName,
        securityToken = securityToken,
        sourceControlName = sourceControlName,
        sourceType = sourceType,
    )
}
