@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.RunbookAssociationPropertyResponse
import com.pulumi.azurenative.automation.kotlin.outputs.RunbookAssociationPropertyResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Webhook].
 */
@PulumiTagMarker
public class WebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebhookArgs = WebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebhookArgsBuilder.() -> Unit) {
        val builder = WebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Webhook {
        val builtJavaResource = com.pulumi.azurenative.automation.Webhook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Webhook(builtJavaResource)
    }
}

/**
 * Definition of the webhook type.
 * Azure REST API version: 2015-10-31. Prior API version in Azure Native 1.x: 2015-10-31.
 * Other available API versions: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update webhook
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webhook = new AzureNative.Automation.Webhook("webhook", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ExpiryTime = "2018-03-29T22:18:13.7002872Z",
 *         IsEnabled = true,
 *         Name = "TestWebhook",
 *         ResourceGroupName = "rg",
 *         Runbook = new AzureNative.Automation.Inputs.RunbookAssociationPropertyArgs
 *         {
 *             Name = "TestRunbook",
 *         },
 *         Uri = "<uri>",
 *         WebhookName = "TestWebhook",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewWebhook(ctx, "webhook", &automation.WebhookArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ExpiryTime:            pulumi.String("2018-03-29T22:18:13.7002872Z"),
 * 			IsEnabled:             pulumi.Bool(true),
 * 			Name:                  pulumi.String("TestWebhook"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Runbook: &automation.RunbookAssociationPropertyArgs{
 * 				Name: pulumi.String("TestRunbook"),
 * 			},
 * 			Uri:         pulumi.String("<uri>"),
 * 			WebhookName: pulumi.String("TestWebhook"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Webhook;
 * import com.pulumi.azurenative.automation.WebhookArgs;
 * import com.pulumi.azurenative.automation.inputs.RunbookAssociationPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webhook = new Webhook("webhook", WebhookArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .expiryTime("2018-03-29T22:18:13.7002872Z")
 *             .isEnabled(true)
 *             .name("TestWebhook")
 *             .resourceGroupName("rg")
 *             .runbook(RunbookAssociationPropertyArgs.builder()
 *                 .name("TestRunbook")
 *                 .build())
 *             .uri("<uri>")
 *             .webhookName("TestWebhook")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Webhook TestWebhook /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/{webhookName}
 * ```
 */
public class Webhook internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Webhook,
) : KotlinCustomResource(javaResource, WebhookMapper) {
    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the expiry time.
     */
    public val expiryTime: Output<String>?
        get() = javaResource.expiryTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the value of the enabled flag of the webhook.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the last invoked time.
     */
    public val lastInvokedTime: Output<String>?
        get() = javaResource.lastInvokedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Details of the user who last modified the Webhook
     */
    public val lastModifiedBy: Output<String>?
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the parameters of the job that is created when the webhook calls the runbook it is associated with.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the name of the hybrid worker group the webhook job will run on.
     */
    public val runOn: Output<String>?
        get() = javaResource.runOn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the runbook the webhook is associated with.
     */
    public val runbook: Output<RunbookAssociationPropertyResponse>?
        get() = javaResource.runbook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the webhook uri.
     */
    public val uri: Output<String>?
        get() = javaResource.uri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WebhookMapper : ResourceMapper<Webhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Webhook::class == javaResource::class

    override fun map(javaResource: Resource): Webhook = Webhook(
        javaResource as
            com.pulumi.azurenative.automation.Webhook,
    )
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Webhook].
 */
public suspend fun webhook(name: String, block: suspend WebhookResourceBuilder.() -> Unit):
    Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webhook(name: String): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
