@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The token type. Must be either PersonalAccessToken or Oauth.
 */
public enum class TokenType(
    public val javaValue: com.pulumi.azurenative.automation.enums.TokenType,
) : ConvertibleToJava<com.pulumi.azurenative.automation.enums.TokenType> {
    PersonalAccessToken(com.pulumi.azurenative.automation.enums.TokenType.PersonalAccessToken),
    Oauth(com.pulumi.azurenative.automation.enums.TokenType.Oauth),
    ;

    override fun toJava(): com.pulumi.azurenative.automation.enums.TokenType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.enums.TokenType): TokenType =
            TokenType.values().first { it.javaValue == javaType }
    }
}
