@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.AdvancedScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of the create Advanced Schedule.
 * @property monthDays Days of the month that the job should execute on. Must be between 1 and 31.
 * @property monthlyOccurrences Occurrences of days within a month.
 * @property weekDays Days of the week that the job should execute on.
 */
public data class AdvancedScheduleArgs(
    public val monthDays: Output<List<Int>>? = null,
    public val monthlyOccurrences: Output<List<AdvancedScheduleMonthlyOccurrenceArgs>>? = null,
    public val weekDays: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.AdvancedScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.AdvancedScheduleArgs =
        com.pulumi.azurenative.automation.inputs.AdvancedScheduleArgs.builder()
            .monthDays(monthDays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monthlyOccurrences(
                monthlyOccurrences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .weekDays(weekDays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AdvancedScheduleArgs].
 */
@PulumiTagMarker
public class AdvancedScheduleArgsBuilder internal constructor() {
    private var monthDays: Output<List<Int>>? = null

    private var monthlyOccurrences: Output<List<AdvancedScheduleMonthlyOccurrenceArgs>>? = null

    private var weekDays: Output<List<String>>? = null

    /**
     * @param value Days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("hhcpmctvwluryxqh")
    public suspend fun monthDays(`value`: Output<List<Int>>) {
        this.monthDays = value
    }

    @JvmName("rmrkpyeuscvyqifb")
    public suspend fun monthDays(vararg values: Output<Int>) {
        this.monthDays = Output.all(values.asList())
    }

    /**
     * @param values Days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("depnlyjyrffghlsb")
    public suspend fun monthDays(values: List<Output<Int>>) {
        this.monthDays = Output.all(values)
    }

    /**
     * @param value Occurrences of days within a month.
     */
    @JvmName("tdcsospqdnjtflho")
    public suspend
    fun monthlyOccurrences(`value`: Output<List<AdvancedScheduleMonthlyOccurrenceArgs>>) {
        this.monthlyOccurrences = value
    }

    @JvmName("iegpqqwmmsrhnosm")
    public suspend fun monthlyOccurrences(
        vararg
        values: Output<AdvancedScheduleMonthlyOccurrenceArgs>,
    ) {
        this.monthlyOccurrences = Output.all(values.asList())
    }

    /**
     * @param values Occurrences of days within a month.
     */
    @JvmName("elqdopxxjcjpwjmd")
    public suspend
    fun monthlyOccurrences(values: List<Output<AdvancedScheduleMonthlyOccurrenceArgs>>) {
        this.monthlyOccurrences = Output.all(values)
    }

    /**
     * @param value Days of the week that the job should execute on.
     */
    @JvmName("vpugmnlilnopnbnc")
    public suspend fun weekDays(`value`: Output<List<String>>) {
        this.weekDays = value
    }

    @JvmName("cbigjvytclqvohfm")
    public suspend fun weekDays(vararg values: Output<String>) {
        this.weekDays = Output.all(values.asList())
    }

    /**
     * @param values Days of the week that the job should execute on.
     */
    @JvmName("hymgebpnsslcmpgo")
    public suspend fun weekDays(values: List<Output<String>>) {
        this.weekDays = Output.all(values)
    }

    /**
     * @param value Days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("wgjmvjyyyedywrct")
    public suspend fun monthDays(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param values Days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("fqpdrdnejiykhkcm")
    public suspend fun monthDays(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param value Occurrences of days within a month.
     */
    @JvmName("dtrgmjninwcqjfja")
    public suspend fun monthlyOccurrences(`value`: List<AdvancedScheduleMonthlyOccurrenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument Occurrences of days within a month.
     */
    @JvmName("scmvaiybnnchomaa")
    public suspend
    fun monthlyOccurrences(argument: List<suspend AdvancedScheduleMonthlyOccurrenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AdvancedScheduleMonthlyOccurrenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument Occurrences of days within a month.
     */
    @JvmName("ddpxdwotkefykltd")
    public suspend fun monthlyOccurrences(
        vararg
        argument: suspend AdvancedScheduleMonthlyOccurrenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AdvancedScheduleMonthlyOccurrenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument Occurrences of days within a month.
     */
    @JvmName("jqvaenbjxastiaqq")
    public suspend
    fun monthlyOccurrences(argument: suspend AdvancedScheduleMonthlyOccurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AdvancedScheduleMonthlyOccurrenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param values Occurrences of days within a month.
     */
    @JvmName("dpwgtitaxecmystt")
    public suspend fun monthlyOccurrences(vararg values: AdvancedScheduleMonthlyOccurrenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthlyOccurrences = mapped
    }

    /**
     * @param value Days of the week that the job should execute on.
     */
    @JvmName("gaccrsfbghrfwbty")
    public suspend fun weekDays(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    /**
     * @param values Days of the week that the job should execute on.
     */
    @JvmName("sqtmeqogbgbiqfhk")
    public suspend fun weekDays(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    internal fun build(): AdvancedScheduleArgs = AdvancedScheduleArgs(
        monthDays = monthDays,
        monthlyOccurrences = monthlyOccurrences,
        weekDays = weekDays,
    )
}
