@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.ContentLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the content link.
 * @property contentHash Gets or sets the hash.
 * @property uri Gets or sets the uri of the runbook content.
 * @property version Gets or sets the version of the content.
 */
public data class ContentLinkArgs(
    public val contentHash: Output<ContentHashArgs>? = null,
    public val uri: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.ContentLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.ContentLinkArgs =
        com.pulumi.azurenative.automation.inputs.ContentLinkArgs.builder()
            .contentHash(contentHash?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uri(uri?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentLinkArgs].
 */
@PulumiTagMarker
public class ContentLinkArgsBuilder internal constructor() {
    private var contentHash: Output<ContentHashArgs>? = null

    private var uri: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Gets or sets the hash.
     */
    @JvmName("onxpvvecwdlkrssj")
    public suspend fun contentHash(`value`: Output<ContentHashArgs>) {
        this.contentHash = value
    }

    /**
     * @param value Gets or sets the uri of the runbook content.
     */
    @JvmName("wvxxlkgshyplmqqf")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Gets or sets the version of the content.
     */
    @JvmName("rmgshvdahldmtmsy")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Gets or sets the hash.
     */
    @JvmName("hqwmbyfrjkogtfbd")
    public suspend fun contentHash(`value`: ContentHashArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHash = mapped
    }

    /**
     * @param argument Gets or sets the hash.
     */
    @JvmName("mvfmhgdfbjtpssly")
    public suspend fun contentHash(argument: suspend ContentHashArgsBuilder.() -> Unit) {
        val toBeMapped = ContentHashArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentHash = mapped
    }

    /**
     * @param value Gets or sets the uri of the runbook content.
     */
    @JvmName("frhppiabigulgetv")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Gets or sets the version of the content.
     */
    @JvmName("qwrlraevujckdgqh")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ContentLinkArgs = ContentLinkArgs(
        contentHash = contentHash,
        uri = uri,
        version = version,
    )
}
