@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.EncryptionPropertiesArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.EncryptionKeySourceType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption settings for automation account
 * @property identity User identity used for CMK.
 * @property keySource Encryption Key Source
 * @property keyVaultProperties Key vault properties.
 */
public data class EncryptionPropertiesArgs(
    public val identity: Output<EncryptionPropertiesIdentityArgs>? = null,
    public val keySource: Output<EncryptionKeySourceType>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.EncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.EncryptionPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.EncryptionPropertiesArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keySource(keySource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesArgsBuilder internal constructor() {
    private var identity: Output<EncryptionPropertiesIdentityArgs>? = null

    private var keySource: Output<EncryptionKeySourceType>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    /**
     * @param value User identity used for CMK.
     */
    @JvmName("qdymerlofaxduskh")
    public suspend fun identity(`value`: Output<EncryptionPropertiesIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Encryption Key Source
     */
    @JvmName("vyetqlxmfxkdvibc")
    public suspend fun keySource(`value`: Output<EncryptionKeySourceType>) {
        this.keySource = value
    }

    /**
     * @param value Key vault properties.
     */
    @JvmName("juqjkhtiqoycvhvt")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value User identity used for CMK.
     */
    @JvmName("lvqbfnglvauhgdmx")
    public suspend fun identity(`value`: EncryptionPropertiesIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument User identity used for CMK.
     */
    @JvmName("nwimflwgdxcuwgmw")
    public suspend
    fun identity(argument: suspend EncryptionPropertiesIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Encryption Key Source
     */
    @JvmName("aeokqwjqjtkmcrbv")
    public suspend fun keySource(`value`: EncryptionKeySourceType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Key vault properties.
     */
    @JvmName("dkmytnqkcwytaxdj")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Key vault properties.
     */
    @JvmName("bhfiovexhopnqmjy")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): EncryptionPropertiesArgs = EncryptionPropertiesArgs(
        identity = identity,
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
    )
}
