@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetDscConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property configurationName The configuration name.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetDscConfigurationPlainArgs(
    public val automationAccountName: String,
    public val configurationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetDscConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetDscConfigurationPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetDscConfigurationPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .configurationName(configurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDscConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetDscConfigurationPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var configurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("mlcdupwqtfcpadxe")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The configuration name.
     */
    @JvmName("sjqpbhvmoifynptn")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("kriqbpxfclpmeuks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDscConfigurationPlainArgs = GetDscConfigurationPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
