@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetJobSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property jobScheduleId The job schedule name.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetJobSchedulePlainArgs(
    public val automationAccountName: String,
    public val jobScheduleId: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetJobSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetJobSchedulePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetJobSchedulePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .jobScheduleId(jobScheduleId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetJobSchedulePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var jobScheduleId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ptvxdsrqxgyomnxh")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The job schedule name.
     */
    @JvmName("chipnwdpmuahnvqg")
    public suspend fun jobScheduleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobScheduleId = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("banuwuffcxxxxbwe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobSchedulePlainArgs = GetJobSchedulePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        jobScheduleId = jobScheduleId ?: throw PulumiNullFieldException("jobScheduleId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
