@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetModulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property moduleName The module name.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetModulePlainArgs(
    public val automationAccountName: String,
    public val moduleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetModulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetModulePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetModulePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .moduleName(moduleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModulePlainArgs].
 */
@PulumiTagMarker
public class GetModulePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var moduleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("cdcufdgvweqftlse")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The module name.
     */
    @JvmName("foxxefwvtnuwpveh")
    public suspend fun moduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.moduleName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("vaeyqbuqshpcckvx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetModulePlainArgs = GetModulePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        moduleName = moduleName ?: throw PulumiNullFieldException("moduleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
