@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetPowerShell72ModulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property moduleName The name of module.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPowerShell72ModulePlainArgs(
    public val automationAccountName: String,
    public val moduleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetPowerShell72ModulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetPowerShell72ModulePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetPowerShell72ModulePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .moduleName(moduleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPowerShell72ModulePlainArgs].
 */
@PulumiTagMarker
public class GetPowerShell72ModulePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var moduleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("xtbsybnwkyhecfpr")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The name of module.
     */
    @JvmName("bbxftirawrmajbpt")
    public suspend fun moduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.moduleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iqkbahbimxiuflhq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPowerShell72ModulePlainArgs = GetPowerShell72ModulePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        moduleName = moduleName ?: throw PulumiNullFieldException("moduleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
