@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.SUCSchedulePropertiesArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.ScheduleFrequency
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of schedule parameters.
 * @property advancedSchedule Gets or sets the advanced schedule.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property expiryTime Gets or sets the end time of the schedule.
 * @property expiryTimeOffsetMinutes Gets or sets the expiry time's offset in minutes.
 * @property frequency Gets or sets the frequency of the schedule.
 * @property interval Gets or sets the interval of the schedule.
 * @property isEnabled Gets or sets a value indicating whether this schedule is enabled.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property nextRun Gets or sets the next run time of the schedule.
 * @property nextRunOffsetMinutes Gets or sets the next run time's offset in minutes.
 * @property startTime Gets or sets the start time of the schedule.
 * @property timeZone Gets or sets the time zone of the schedule.
 */
public data class SUCSchedulePropertiesArgs(
    public val advancedSchedule: Output<AdvancedScheduleArgs>? = null,
    public val creationTime: Output<String>? = null,
    public val description: Output<String>? = null,
    public val expiryTime: Output<String>? = null,
    public val expiryTimeOffsetMinutes: Output<Double>? = null,
    public val frequency: Output<Either<String, ScheduleFrequency>>? = null,
    public val interval: Output<Double>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val lastModifiedTime: Output<String>? = null,
    public val nextRun: Output<String>? = null,
    public val nextRunOffsetMinutes: Output<Double>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.SUCSchedulePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.SUCSchedulePropertiesArgs =
        com.pulumi.azurenative.automation.inputs.SUCSchedulePropertiesArgs.builder()
            .advancedSchedule(advancedSchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .creationTime(creationTime?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .expiryTime(expiryTime?.applyValue({ args0 -> args0 }))
            .expiryTimeOffsetMinutes(expiryTimeOffsetMinutes?.applyValue({ args0 -> args0 }))
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .lastModifiedTime(lastModifiedTime?.applyValue({ args0 -> args0 }))
            .nextRun(nextRun?.applyValue({ args0 -> args0 }))
            .nextRunOffsetMinutes(nextRunOffsetMinutes?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SUCSchedulePropertiesArgs].
 */
@PulumiTagMarker
public class SUCSchedulePropertiesArgsBuilder internal constructor() {
    private var advancedSchedule: Output<AdvancedScheduleArgs>? = null

    private var creationTime: Output<String>? = null

    private var description: Output<String>? = null

    private var expiryTime: Output<String>? = null

    private var expiryTimeOffsetMinutes: Output<Double>? = null

    private var frequency: Output<Either<String, ScheduleFrequency>>? = null

    private var interval: Output<Double>? = null

    private var isEnabled: Output<Boolean>? = null

    private var lastModifiedTime: Output<String>? = null

    private var nextRun: Output<String>? = null

    private var nextRunOffsetMinutes: Output<Double>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Gets or sets the advanced schedule.
     */
    @JvmName("uqmagfoqsggohnye")
    public suspend fun advancedSchedule(`value`: Output<AdvancedScheduleArgs>) {
        this.advancedSchedule = value
    }

    /**
     * @param value Gets or sets the creation time.
     */
    @JvmName("trdqfoaaufuqtevc")
    public suspend fun creationTime(`value`: Output<String>) {
        this.creationTime = value
    }

    /**
     * @param value Gets or sets the description.
     */
    @JvmName("etwqrbaiesuoepvj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the end time of the schedule.
     */
    @JvmName("lwahmovcahfyljcr")
    public suspend fun expiryTime(`value`: Output<String>) {
        this.expiryTime = value
    }

    /**
     * @param value Gets or sets the expiry time's offset in minutes.
     */
    @JvmName("uayqfpgfjdiiqowr")
    public suspend fun expiryTimeOffsetMinutes(`value`: Output<Double>) {
        this.expiryTimeOffsetMinutes = value
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("lcxuylfrmnuvwikl")
    public suspend fun frequency(`value`: Output<Either<String, ScheduleFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value Gets or sets the interval of the schedule.
     */
    @JvmName("ciwvhigqetjpspqx")
    public suspend fun interval(`value`: Output<Double>) {
        this.interval = value
    }

    /**
     * @param value Gets or sets a value indicating whether this schedule is enabled.
     */
    @JvmName("qaqogrtrcmwkqyhv")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Gets or sets the last modified time.
     */
    @JvmName("dfeyrnsobtntfwtt")
    public suspend fun lastModifiedTime(`value`: Output<String>) {
        this.lastModifiedTime = value
    }

    /**
     * @param value Gets or sets the next run time of the schedule.
     */
    @JvmName("uwkjgklbdwcmyhdi")
    public suspend fun nextRun(`value`: Output<String>) {
        this.nextRun = value
    }

    /**
     * @param value Gets or sets the next run time's offset in minutes.
     */
    @JvmName("urarfdcbmgrtjlli")
    public suspend fun nextRunOffsetMinutes(`value`: Output<Double>) {
        this.nextRunOffsetMinutes = value
    }

    /**
     * @param value Gets or sets the start time of the schedule.
     */
    @JvmName("lhheiqhawxyqkdhp")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Gets or sets the time zone of the schedule.
     */
    @JvmName("pmmqrcklqjbjecmv")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Gets or sets the advanced schedule.
     */
    @JvmName("pbrjiwbpqhojlshw")
    public suspend fun advancedSchedule(`value`: AdvancedScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedSchedule = mapped
    }

    /**
     * @param argument Gets or sets the advanced schedule.
     */
    @JvmName("fsvtoutapcqkqnnd")
    public suspend fun advancedSchedule(argument: suspend AdvancedScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = AdvancedScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.advancedSchedule = mapped
    }

    /**
     * @param value Gets or sets the creation time.
     */
    @JvmName("clbwiicrappysctl")
    public suspend fun creationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationTime = mapped
    }

    /**
     * @param value Gets or sets the description.
     */
    @JvmName("wdbjvfcxdogpcprt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the end time of the schedule.
     */
    @JvmName("pxnhskxtlfhbahgs")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTime = mapped
    }

    /**
     * @param value Gets or sets the expiry time's offset in minutes.
     */
    @JvmName("pnqtolnqprqgfeea")
    public suspend fun expiryTimeOffsetMinutes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTimeOffsetMinutes = mapped
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("cqmjykrcqtjgeven")
    public suspend fun frequency(`value`: Either<String, ScheduleFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("dnvpqxoeguvojvld")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("xnbirchcdwwxocab")
    public fun frequency(`value`: ScheduleFrequency) {
        val toBeMapped = Either.ofRight<String, ScheduleFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the interval of the schedule.
     */
    @JvmName("nhxemhgbuhxneswr")
    public suspend fun interval(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether this schedule is enabled.
     */
    @JvmName("cdvabvugayfhubrq")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Gets or sets the last modified time.
     */
    @JvmName("rggmginfwnqnbtmr")
    public suspend fun lastModifiedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedTime = mapped
    }

    /**
     * @param value Gets or sets the next run time of the schedule.
     */
    @JvmName("kndclhmxvgnhaxof")
    public suspend fun nextRun(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextRun = mapped
    }

    /**
     * @param value Gets or sets the next run time's offset in minutes.
     */
    @JvmName("jpjspjvqpcraefps")
    public suspend fun nextRunOffsetMinutes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextRunOffsetMinutes = mapped
    }

    /**
     * @param value Gets or sets the start time of the schedule.
     */
    @JvmName("xcbqmruajuqxojye")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Gets or sets the time zone of the schedule.
     */
    @JvmName("vptivdnfbbraalqe")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): SUCSchedulePropertiesArgs = SUCSchedulePropertiesArgs(
        advancedSchedule = advancedSchedule,
        creationTime = creationTime,
        description = description,
        expiryTime = expiryTime,
        expiryTimeOffsetMinutes = expiryTimeOffsetMinutes,
        frequency = frequency,
        interval = interval,
        isEnabled = isEnabled,
        lastModifiedTime = lastModifiedTime,
        nextRun = nextRun,
        nextRunOffsetMinutes = nextRunOffsetMinutes,
        startTime = startTime,
        timeZone = timeZone,
    )
}
