@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.SkuArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.SkuNameEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The account SKU.
 * @property capacity Gets or sets the SKU capacity.
 * @property family Gets or sets the SKU family.
 * @property name Gets or sets the SKU name of the account.
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<Either<String, SkuNameEnum>>,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.SkuArgs =
        com.pulumi.azurenative.automation.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<Either<String, SkuNameEnum>>? = null

    /**
     * @param value Gets or sets the SKU capacity.
     */
    @JvmName("clrlkptnpadnjdxt")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Gets or sets the SKU family.
     */
    @JvmName("gorkytmjbdgbpvgi")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Gets or sets the SKU name of the account.
     */
    @JvmName("kiybetutolxegamf")
    public suspend fun name(`value`: Output<Either<String, SkuNameEnum>>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the SKU capacity.
     */
    @JvmName("gspvajtyewsxscgh")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Gets or sets the SKU family.
     */
    @JvmName("pfjhhpixtikxjutx")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Gets or sets the SKU name of the account.
     */
    @JvmName("wqprtdbhgewqschy")
    public suspend fun name(`value`: Either<String, SkuNameEnum>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the SKU name of the account.
     */
    @JvmName("hqjanitjkawsjwyp")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuNameEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the SKU name of the account.
     */
    @JvmName("mmeiuutaagetpvab")
    public fun name(`value`: SkuNameEnum) {
        val toBeMapped = Either.ofRight<String, SkuNameEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
