@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the content link.
 * @property contentHash Gets or sets the hash.
 * @property uri Gets or sets the uri of the runbook content.
 * @property version Gets or sets the version of the content.
 */
public data class ContentLinkResponse(
    public val contentHash: ContentHashResponse? = null,
    public val uri: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.ContentLinkResponse):
            ContentLinkResponse = ContentLinkResponse(
            contentHash = javaType.contentHash().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentHashResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
