@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the content source.
 * @property hash Gets or sets the hash.
 * @property type Gets or sets the content source type.
 * @property value Gets or sets the value of the content. This is based on the content source type.
 * @property version Gets or sets the version of the content.
 */
public data class ContentSourceResponse(
    public val hash: ContentHashResponse? = null,
    public val type: String? = null,
    public val `value`: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.ContentSourceResponse):
            ContentSourceResponse = ContentSourceResponse(
            hash = javaType.hash().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentHashResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
