@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the configuration type.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property etag Gets or sets the etag of the resource.
 * @property id Fully qualified resource Id for the resource
 * @property jobCount Gets or sets the job count of the configuration.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property location The Azure Region where the resource lives
 * @property logVerbose Gets or sets verbose log option.
 * @property name The name of the resource
 * @property nodeConfigurationCount Gets the number of compiled node configurations.
 * @property parameters Gets or sets the configuration parameters.
 * @property provisioningState Gets or sets the provisioning state of the configuration.
 * @property source Gets or sets the source.
 * @property state Gets or sets the state of the configuration.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetDscConfigurationResult(
    public val creationTime: String? = null,
    public val description: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val jobCount: Int? = null,
    public val lastModifiedTime: String? = null,
    public val location: String? = null,
    public val logVerbose: Boolean? = null,
    public val name: String,
    public val nodeConfigurationCount: Int? = null,
    public val parameters: Map<String, DscConfigurationParameterResponse>? = null,
    public val provisioningState: String? = null,
    public val source: ContentSourceResponse? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetDscConfigurationResult):
            GetDscConfigurationResult = GetDscConfigurationResult(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            jobCount = javaType.jobCount().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            logVerbose = javaType.logVerbose().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nodeConfigurationCount = javaType.nodeConfigurationCount().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.automation.kotlin.outputs.DscConfigurationParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
