@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the dsc node configuration.
 * @property configuration Gets or sets the configuration of the node.
 * @property creationTime Gets or sets creation time.
 * @property id Fully qualified resource Id for the resource
 * @property incrementNodeConfigurationBuild If a new build version of NodeConfiguration is required.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property name The name of the resource
 * @property nodeCount Number of nodes with this node configuration assigned
 * @property source Source of node configuration.
 * @property type The type of the resource.
 */
public data class GetDscNodeConfigurationResult(
    public val configuration: DscConfigurationAssociationPropertyResponse? = null,
    public val creationTime: String? = null,
    public val id: String,
    public val incrementNodeConfigurationBuild: Boolean? = null,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val nodeCount: Double? = null,
    public val source: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetDscNodeConfigurationResult):
            GetDscNodeConfigurationResult = GetDscNodeConfigurationResult(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.DscConfigurationAssociationPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            incrementNodeConfigurationBuild = javaType.incrementNodeConfigurationBuild().map({ args0 ->
                args0
            }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
