@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the module type.
 * @property activityCount Gets or sets the activity count of the module.
 * @property contentLink Gets or sets the contentLink of the module.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property error Gets or sets the error info of the module.
 * @property etag Gets or sets the etag of the resource.
 * @property id Fully qualified resource Id for the resource
 * @property isComposite Gets or sets type of module, if its composite or not.
 * @property isGlobal Gets or sets the isGlobal flag of the module.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property location The Azure Region where the resource lives
 * @property name The name of the resource
 * @property provisioningState Gets or sets the provisioning state of the module.
 * @property sizeInBytes Gets or sets the size in bytes of the module.
 * @property tags Resource tags.
 * @property type The type of the resource.
 * @property version Gets or sets the version of the module.
 */
public data class GetPython3PackageResult(
    public val activityCount: Int? = null,
    public val contentLink: ContentLinkResponse? = null,
    public val creationTime: String? = null,
    public val description: String? = null,
    public val error: ModuleErrorInfoResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val isComposite: Boolean? = null,
    public val isGlobal: Boolean? = null,
    public val lastModifiedTime: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String? = null,
    public val sizeInBytes: Double? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetPython3PackageResult):
            GetPython3PackageResult = GetPython3PackageResult(
            activityCount = javaType.activityCount().map({ args0 -> args0 }).orElse(null),
            contentLink = javaType.contentLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ModuleErrorInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isComposite = javaType.isComposite().map({ args0 -> args0 }).orElse(null),
            isGlobal = javaType.isGlobal().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            sizeInBytes = javaType.sizeInBytes().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
