@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the watcher type.
 * @property creationTime Gets or sets the creation time.
 * @property description Gets or sets the description.
 * @property etag Gets or sets the etag of the resource.
 * @property executionFrequencyInSeconds Gets or sets the frequency at which the watcher is invoked.
 * @property id Fully qualified resource Id for the resource
 * @property lastModifiedBy Details of the user who last modified the watcher.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property scriptName Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
 * @property scriptParameters Gets or sets the parameters of the script.
 * @property scriptRunOn Gets or sets the name of the hybrid worker group the watcher will run on.
 * @property status Gets the current status of the watcher.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetWatcherResult(
    public val creationTime: String,
    public val description: String? = null,
    public val etag: String? = null,
    public val executionFrequencyInSeconds: Double? = null,
    public val id: String,
    public val lastModifiedBy: String,
    public val lastModifiedTime: String,
    public val location: String? = null,
    public val name: String,
    public val scriptName: String? = null,
    public val scriptParameters: Map<String, String>? = null,
    public val scriptRunOn: String? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetWatcherResult):
            GetWatcherResult = GetWatcherResult(
            creationTime = javaType.creationTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            executionFrequencyInSeconds = javaType.executionFrequencyInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            lastModifiedBy = javaType.lastModifiedBy(),
            lastModifiedTime = javaType.lastModifiedTime(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scriptName = javaType.scriptName().map({ args0 -> args0 }).orElse(null),
            scriptParameters = javaType.scriptParameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            scriptRunOn = javaType.scriptRunOn().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
