@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the module error info type.
 * @property code Gets or sets the error code.
 * @property message Gets or sets the error message.
 */
public data class ModuleErrorInfoResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.ModuleErrorInfoResponse):
            ModuleErrorInfoResponse = ModuleErrorInfoResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
