@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Windows specific update configuration.
 * @property excludedKbNumbers KB numbers excluded from the software update configuration.
 * @property includedKbNumbers KB numbers included from the software update configuration.
 * @property includedUpdateClassifications Update classification included in the software update configuration. A comma separated string with required values
 * @property rebootSetting Reboot setting for the software update configuration.
 */
public data class WindowsPropertiesResponse(
    public val excludedKbNumbers: List<String>? = null,
    public val includedKbNumbers: List<String>? = null,
    public val includedUpdateClassifications: String? = null,
    public val rebootSetting: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.WindowsPropertiesResponse):
            WindowsPropertiesResponse = WindowsPropertiesResponse(
            excludedKbNumbers = javaType.excludedKbNumbers().map({ args0 -> args0 }),
            includedKbNumbers = javaType.includedKbNumbers().map({ args0 -> args0 }),
            includedUpdateClassifications = javaType.includedUpdateClassifications().map({ args0 ->
                args0
            }).orElse(null),
            rebootSetting = javaType.rebootSetting().map({ args0 -> args0 }).orElse(null),
        )
    }
}
