@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin

import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.DataPoolLocationResponse
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.DataPoolLocationResponse.Companion.toKotlin as dataPoolLocationResponseToKotlin
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataPool].
 */
@PulumiTagMarker
public class DataPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataPoolArgs = DataPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataPoolArgsBuilder.() -> Unit) {
        val builder = DataPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataPool {
        val builtJavaResource =
            com.pulumi.azurenative.autonomousdevelopmentplatform.DataPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataPool(builtJavaResource)
    }
}

/**
 * ADP Data Pool
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * ## Example Usage
 * ### Put Data Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataPool = new AzureNative.AutonomousDevelopmentPlatform.DataPool("dataPool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DataPoolName = "sampledp",
 *         Locations = new[]
 *         {
 *             new AzureNative.AutonomousDevelopmentPlatform.Inputs.DataPoolLocationArgs
 *             {
 *                 Encryption = new AzureNative.AutonomousDevelopmentPlatform.Inputs.DataPoolEncryptionArgs
 *                 {
 *                     KeyName = "key1",
 *                     KeyVaultUri = "https://vaulturi",
 *                     KeyVersion = "123",
 *                     UserAssignedIdentity = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1",
 *                 },
 *                 Name = "westus",
 *             },
 *         },
 *         ResourceGroupName = "adpClient",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/autonomousdevelopmentplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := autonomousdevelopmentplatform.NewDataPool(ctx, "dataPool", &autonomousdevelopmentplatform.DataPoolArgs{
 * 			AccountName:  pulumi.String("sampleacct"),
 * 			DataPoolName: pulumi.String("sampledp"),
 * 			Locations: autonomousdevelopmentplatform.DataPoolLocationArray{
 * 				&autonomousdevelopmentplatform.DataPoolLocationArgs{
 * 					Encryption: &autonomousdevelopmentplatform.DataPoolEncryptionArgs{
 * 						KeyName:              pulumi.String("key1"),
 * 						KeyVaultUri:          pulumi.String("https://vaulturi"),
 * 						KeyVersion:           pulumi.String("123"),
 * 						UserAssignedIdentity: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1"),
 * 					},
 * 					Name: pulumi.String("westus"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("adpClient"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.autonomousdevelopmentplatform.DataPool;
 * import com.pulumi.azurenative.autonomousdevelopmentplatform.DataPoolArgs;
 * import com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolLocationArgs;
 * import com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataPool = new DataPool("dataPool", DataPoolArgs.builder()
 *             .accountName("sampleacct")
 *             .dataPoolName("sampledp")
 *             .locations(DataPoolLocationArgs.builder()
 *                 .encryption(DataPoolEncryptionArgs.builder()
 *                     .keyName("key1")
 *                     .keyVaultUri("https://vaulturi")
 *                     .keyVersion("123")
 *                     .userAssignedIdentity("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1")
 *                     .build())
 *                 .name("westus")
 *                 .build())
 *             .resourceGroupName("adpClient")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:autonomousdevelopmentplatform:DataPool dp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AutonomousDevelopmentPlatform/accounts/{accountName}/dataPools/{dataPoolName}
 * ```
 */
public class DataPool internal constructor(
    override val javaResource: com.pulumi.azurenative.autonomousdevelopmentplatform.DataPool,
) : KotlinCustomResource(javaResource, DataPoolMapper) {
    /**
     * The Data Pool's data-plane ID
     */
    public val dataPoolId: Output<String>
        get() = javaResource.dataPoolId().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the collection of locations where Data Pool resources should be created
     */
    public val locations: Output<List<DataPoolLocationResponse>>
        get() = javaResource.locations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataPoolLocationResponseToKotlin(args0)
                })
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the status of the data pool at the time the operation was called
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataPoolMapper : ResourceMapper<DataPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.autonomousdevelopmentplatform.DataPool::class == javaResource::class

    override fun map(javaResource: Resource): DataPool = DataPool(
        javaResource as
            com.pulumi.azurenative.autonomousdevelopmentplatform.DataPool,
    )
}

/**
 * @see [DataPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataPool].
 */
public suspend fun dataPool(name: String, block: suspend DataPoolResourceBuilder.() -> Unit):
    DataPool {
    val builder = DataPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataPool(name: String): DataPool {
    val builder = DataPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
