@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs

import com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Encryption properties of a Data Pool
 * @property keyName The name of Key Vault key
 * @property keyVaultUri The URI of a soft delete-enabled Key Vault that is in the same location as the Data Pool location
 * @property keyVersion The version of Key Vault key
 * @property userAssignedIdentity The resource ID of a user-assigned Managed Identity used to access the encryption key in the Key Vault. Requires access to the key operations get, wrap, unwrap, and recover
 */
public data class DataPoolEncryptionArgs(
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
    public val keyVersion: Output<String>? = null,
    public val userAssignedIdentity: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolEncryptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolEncryptionArgs =
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolEncryptionArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 }))
            .userAssignedIdentity(userAssignedIdentity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataPoolEncryptionArgs].
 */
@PulumiTagMarker
public class DataPoolEncryptionArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The name of Key Vault key
     */
    @JvmName("vpbtdwyopsylsoyf")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The URI of a soft delete-enabled Key Vault that is in the same location as the Data Pool location
     */
    @JvmName("ictxbawgruvulcvo")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of Key Vault key
     */
    @JvmName("dhrbxusjkmtmcpee")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The resource ID of a user-assigned Managed Identity used to access the encryption key in the Key Vault. Requires access to the key operations get, wrap, unwrap, and recover
     */
    @JvmName("shfxhwfkmpxvcpfh")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The name of Key Vault key
     */
    @JvmName("folidxomsdbpbmdb")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The URI of a soft delete-enabled Key Vault that is in the same location as the Data Pool location
     */
    @JvmName("mlkqtvgftphqvtjq")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of Key Vault key
     */
    @JvmName("xxgtfdhvminltoam")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    /**
     * @param value The resource ID of a user-assigned Managed Identity used to access the encryption key in the Key Vault. Requires access to the key operations get, wrap, unwrap, and recover
     */
    @JvmName("lawnpbrvyjfcmrdg")
    public suspend fun userAssignedIdentity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): DataPoolEncryptionArgs = DataPoolEncryptionArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        keyVersion = keyVersion,
        userAssignedIdentity = userAssignedIdentity ?: throw
            PulumiNullFieldException("userAssignedIdentity"),
    )
}
