@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs

import com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.StorageSkuArgs.builder
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.enums.StorageSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Storage SKU.
 * @property name The SKU name
 */
public data class StorageSkuArgs(
    public val name: Output<Either<String, StorageSkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.StorageSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.StorageSkuArgs =
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.StorageSkuArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageSkuArgs].
 */
@PulumiTagMarker
public class StorageSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, StorageSkuName>>? = null

    /**
     * @param value The SKU name
     */
    @JvmName("jiwdbndxcwqolojg")
    public suspend fun name(`value`: Output<Either<String, StorageSkuName>>) {
        this.name = value
    }

    /**
     * @param value The SKU name
     */
    @JvmName("lipkjkipkgkmcsbj")
    public suspend fun name(`value`: Either<String, StorageSkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU name
     */
    @JvmName("gxxwiscqfkwlsnwx")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU name
     */
    @JvmName("snminxvtpjbxyedj")
    public fun name(`value`: StorageSkuName) {
        val toBeMapped = Either.ofRight<String, StorageSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): StorageSkuArgs = StorageSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
