@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * ADP Data Pool
 * @property dataPoolId The Data Pool's data-plane ID
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property locations Gets or sets the collection of locations where Data Pool resources should be created
 * @property name The name of the resource
 * @property provisioningState Gets the status of the data pool at the time the operation was called
 * @property systemData The system meta data relating to this resource
 * @property tags Resource tags
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDataPoolResult(
    public val dataPoolId: String,
    public val id: String,
    public val locations: List<DataPoolLocationResponse>,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.autonomousdevelopmentplatform.outputs.GetDataPoolResult):
            GetDataPoolResult = GetDataPoolResult(
            dataPoolId = javaType.dataPoolId(),
            id = javaType.id(),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.DataPoolLocationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
