@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Addon].
 */
@PulumiTagMarker
public class AddonResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AddonArgs = AddonArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AddonArgsBuilder.() -> Unit) {
        val builder = AddonArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Addon {
        val builtJavaResource = com.pulumi.azurenative.avs.Addon(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Addon(builtJavaResource)
    }
}

/**
 * An addon resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2021-01-01-preview, 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### Addons_CreateOrUpdate_Arc
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "arc",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonArcPropertiesArgs
 *         {
 *             AddonType = "Arc",
 *             VCenter = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("arc"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonArcProperties{
 * 				AddonType: "Arc",
 * 				VCenter:   "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("arc")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("Arc")
 *                 .vCenter("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ### Addons_CreateOrUpdate_HCX
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "hcx",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonHcxPropertiesArgs
 *         {
 *             AddonType = "HCX",
 *             Offer = "VMware MaaS Cloud Provider (Enterprise)",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("hcx"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonHcxProperties{
 * 				AddonType: "HCX",
 * 				Offer:     "VMware MaaS Cloud Provider (Enterprise)",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("hcx")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("HCX")
 *                 .offer("VMware MaaS Cloud Provider (Enterprise)")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ### Addons_CreateOrUpdate_SRM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "srm",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonSrmPropertiesArgs
 *         {
 *             AddonType = "SRM",
 *             LicenseKey = "41915178-A8FF-4A4D-B683-6D735AF5E3F5",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("srm"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonSrmProperties{
 * 				AddonType:  "SRM",
 * 				LicenseKey: "41915178-A8FF-4A4D-B683-6D735AF5E3F5",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("srm")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("SRM")
 *                 .licenseKey("41915178-A8FF-4A4D-B683-6D735AF5E3F5")
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ### Addons_CreateOrUpdate_VR
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addon = new AzureNative.AVS.Addon("addon", new()
 *     {
 *         AddonName = "vr",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.AddonVrPropertiesArgs
 *         {
 *             AddonType = "VR",
 *             VrsCount = 1,
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAddon(ctx, "addon", &avs.AddonArgs{
 * 			AddonName:        pulumi.String("vr"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.AddonVrProperties{
 * 				AddonType: "VR",
 * 				VrsCount:  1,
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Addon;
 * import com.pulumi.azurenative.avs.AddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addon = new Addon("addon", AddonArgs.builder()
 *             .addonName("vr")
 *             .privateCloudName("cloud1")
 *             .properties(AddonArcPropertiesArgs.builder()
 *                 .addonType("VR")
 *                 .vrsCount(1)
 *                 .build())
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Addon vr /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/addons/{addonName}
 * ```
 */
public class Addon internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.Addon,
) : KotlinCustomResource(javaResource, AddonMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of an addon resource
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AddonMapper : ResourceMapper<Addon> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.Addon::class == javaResource::class

    override fun map(javaResource: Resource): Addon = Addon(
        javaResource as
            com.pulumi.azurenative.avs.Addon,
    )
}

/**
 * @see [Addon].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Addon].
 */
public suspend fun addon(name: String, block: suspend AddonResourceBuilder.() -> Unit): Addon {
    val builder = AddonResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Addon].
 * @param name The _unique_ name of the resulting resource.
 */
public fun addon(name: String): Addon {
    val builder = AddonResourceBuilder()
    builder.name(name)
    return builder.build()
}
