@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.HcxEnterpriseSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An HCX Enterprise Site resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-03-20.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### HcxEnterpriseSites_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hcxEnterpriseSite = new AzureNative.AVS.HcxEnterpriseSite("hcxEnterpriseSite", new()
 *     {
 *         HcxEnterpriseSiteName = "site1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewHcxEnterpriseSite(ctx, "hcxEnterpriseSite", &avs.HcxEnterpriseSiteArgs{
 * 			HcxEnterpriseSiteName: pulumi.String("site1"),
 * 			PrivateCloudName:      pulumi.String("cloud1"),
 * 			ResourceGroupName:     pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.HcxEnterpriseSite;
 * import com.pulumi.azurenative.avs.HcxEnterpriseSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hcxEnterpriseSite = new HcxEnterpriseSite("hcxEnterpriseSite", HcxEnterpriseSiteArgs.builder()
 *             .hcxEnterpriseSiteName("site1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:HcxEnterpriseSite site1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/hcxEnterpriseSites/{hcxEnterpriseSiteName}
 * ```
 * @property hcxEnterpriseSiteName Name of the HCX Enterprise Site in the private cloud
 * @property privateCloudName The name of the private cloud.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class HcxEnterpriseSiteArgs(
    public val hcxEnterpriseSiteName: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.HcxEnterpriseSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.HcxEnterpriseSiteArgs =
        com.pulumi.azurenative.avs.HcxEnterpriseSiteArgs.builder()
            .hcxEnterpriseSiteName(hcxEnterpriseSiteName?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HcxEnterpriseSiteArgs].
 */
@PulumiTagMarker
public class HcxEnterpriseSiteArgsBuilder internal constructor() {
    private var hcxEnterpriseSiteName: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the HCX Enterprise Site in the private cloud
     */
    @JvmName("uaaeuewquxomoxba")
    public suspend fun hcxEnterpriseSiteName(`value`: Output<String>) {
        this.hcxEnterpriseSiteName = value
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("flvfeagnvgdwbpyn")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kxyacawmuglbxicf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the HCX Enterprise Site in the private cloud
     */
    @JvmName("kwopypiasyqjiqdn")
    public suspend fun hcxEnterpriseSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcxEnterpriseSiteName = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("isdirnaglmhujloj")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("falpwfylcbripqrn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): HcxEnterpriseSiteArgs = HcxEnterpriseSiteArgs(
        hcxEnterpriseSiteName = hcxEnterpriseSiteName,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
    )
}
