@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.avs.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IscsiPath].
 */
@PulumiTagMarker
public class IscsiPathResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IscsiPathArgs = IscsiPathArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IscsiPathArgsBuilder.() -> Unit) {
        val builder = IscsiPathArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IscsiPath {
        val builtJavaResource = com.pulumi.azurenative.avs.IscsiPath(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IscsiPath(builtJavaResource)
    }
}

/**
 * An iSCSI path resource
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### IscsiPaths_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iscsiPath = new AzureNative.AVS.IscsiPath("iscsiPath", new()
 *     {
 *         NetworkBlock = "192.168.0.0/24",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewIscsiPath(ctx, "iscsiPath", &avs.IscsiPathArgs{
 * 			NetworkBlock:      pulumi.String("192.168.0.0/24"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.IscsiPath;
 * import com.pulumi.azurenative.avs.IscsiPathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iscsiPath = new IscsiPath("iscsiPath", IscsiPathArgs.builder()
 *             .networkBlock("192.168.0.0/24")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:IscsiPath default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/iscsiPaths/default
 * ```
 */
public class IscsiPath internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.IscsiPath,
) : KotlinCustomResource(javaResource, IscsiPathMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * CIDR Block for iSCSI path.
     */
    public val networkBlock: Output<String>
        get() = javaResource.networkBlock().applyValue({ args0 -> args0 })

    /**
     * The state of the iSCSI path provisioning
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IscsiPathMapper : ResourceMapper<IscsiPath> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.IscsiPath::class == javaResource::class

    override fun map(javaResource: Resource): IscsiPath = IscsiPath(
        javaResource as
            com.pulumi.azurenative.avs.IscsiPath,
    )
}

/**
 * @see [IscsiPath].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IscsiPath].
 */
public suspend fun iscsiPath(name: String, block: suspend IscsiPathResourceBuilder.() -> Unit):
    IscsiPath {
    val builder = IscsiPathResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IscsiPath].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iscsiPath(name: String): IscsiPath {
    val builder = IscsiPathResourceBuilder()
    builder.name(name)
    return builder.build()
}
