@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.IscsiPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An iSCSI path resource
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### IscsiPaths_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iscsiPath = new AzureNative.AVS.IscsiPath("iscsiPath", new()
 *     {
 *         NetworkBlock = "192.168.0.0/24",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewIscsiPath(ctx, "iscsiPath", &avs.IscsiPathArgs{
 * 			NetworkBlock:      pulumi.String("192.168.0.0/24"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.IscsiPath;
 * import com.pulumi.azurenative.avs.IscsiPathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iscsiPath = new IscsiPath("iscsiPath", IscsiPathArgs.builder()
 *             .networkBlock("192.168.0.0/24")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:IscsiPath default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/iscsiPaths/default
 * ```
 * @property networkBlock CIDR Block for iSCSI path.
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class IscsiPathArgs(
    public val networkBlock: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.IscsiPathArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.IscsiPathArgs =
        com.pulumi.azurenative.avs.IscsiPathArgs.builder()
            .networkBlock(networkBlock?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IscsiPathArgs].
 */
@PulumiTagMarker
public class IscsiPathArgsBuilder internal constructor() {
    private var networkBlock: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value CIDR Block for iSCSI path.
     */
    @JvmName("jbjmuaknepqlyuqg")
    public suspend fun networkBlock(`value`: Output<String>) {
        this.networkBlock = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("fkuyexqrnrruwmdx")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pnsjstauaqngfsyr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value CIDR Block for iSCSI path.
     */
    @JvmName("ueufopnjxtkovkjy")
    public suspend fun networkBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBlock = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("bmoksxhwktdqcxnt")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjuunqcrkxythkfn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): IscsiPathArgs = IscsiPathArgs(
        networkBlock = networkBlock,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
    )
}
