@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.PrivateCloudArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.InternetEnum
import com.pulumi.azurenative.avs.kotlin.inputs.AvailabilityPropertiesArgs
import com.pulumi.azurenative.avs.kotlin.inputs.AvailabilityPropertiesArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.avs.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.IdentitySourceArgs
import com.pulumi.azurenative.avs.kotlin.inputs.IdentitySourceArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.ManagementClusterArgs
import com.pulumi.azurenative.avs.kotlin.inputs.ManagementClusterArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.PrivateCloudIdentityArgs
import com.pulumi.azurenative.avs.kotlin.inputs.PrivateCloudIdentityArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.avs.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A private cloud resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-03-20.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### PrivateClouds_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateCloud = new AzureNative.AVS.PrivateCloud("privateCloud", new()
 *     {
 *         Identity = new AzureNative.AVS.Inputs.PrivateCloudIdentityArgs
 *         {
 *             Type = AzureNative.AVS.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2",
 *         ManagementCluster = new AzureNative.AVS.Inputs.ManagementClusterArgs
 *         {
 *             ClusterSize = 4,
 *         },
 *         NetworkBlock = "192.168.48.0/22",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.AVS.Inputs.SkuArgs
 *         {
 *             Name = "AV36",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewPrivateCloud(ctx, "privateCloud", &avs.PrivateCloudArgs{
 * 			Identity: &avs.PrivateCloudIdentityArgs{
 * 				Type: pulumi.String(avs.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("eastus2"),
 * 			ManagementCluster: &avs.ManagementClusterArgs{
 * 				ClusterSize: pulumi.Int(4),
 * 			},
 * 			NetworkBlock:      pulumi.String("192.168.48.0/22"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &avs.SkuArgs{
 * 				Name: pulumi.String("AV36"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.PrivateCloud;
 * import com.pulumi.azurenative.avs.PrivateCloudArgs;
 * import com.pulumi.azurenative.avs.inputs.PrivateCloudIdentityArgs;
 * import com.pulumi.azurenative.avs.inputs.ManagementClusterArgs;
 * import com.pulumi.azurenative.avs.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateCloud = new PrivateCloud("privateCloud", PrivateCloudArgs.builder()
 *             .identity(PrivateCloudIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus2")
 *             .managementCluster(ManagementClusterArgs.builder()
 *                 .clusterSize(4)
 *                 .build())
 *             .networkBlock("192.168.48.0/22")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .sku(SkuArgs.builder()
 *                 .name("AV36")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateClouds_CreateOrUpdate_Stretched
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateCloud = new AzureNative.AVS.PrivateCloud("privateCloud", new()
 *     {
 *         Availability = new AzureNative.AVS.Inputs.AvailabilityPropertiesArgs
 *         {
 *             SecondaryZone = 2,
 *             Strategy = AzureNative.AVS.AvailabilityStrategy.DualZone,
 *             Zone = 1,
 *         },
 *         Location = "eastus2",
 *         ManagementCluster = new AzureNative.AVS.Inputs.ManagementClusterArgs
 *         {
 *             ClusterSize = 4,
 *         },
 *         NetworkBlock = "192.168.48.0/22",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.AVS.Inputs.SkuArgs
 *         {
 *             Name = "AV36",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewPrivateCloud(ctx, "privateCloud", &avs.PrivateCloudArgs{
 * 			Availability: &avs.AvailabilityPropertiesArgs{
 * 				SecondaryZone: pulumi.Int(2),
 * 				Strategy:      pulumi.String(avs.AvailabilityStrategyDualZone),
 * 				Zone:          pulumi.Int(1),
 * 			},
 * 			Location: pulumi.String("eastus2"),
 * 			ManagementCluster: &avs.ManagementClusterArgs{
 * 				ClusterSize: pulumi.Int(4),
 * 			},
 * 			NetworkBlock:      pulumi.String("192.168.48.0/22"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &avs.SkuArgs{
 * 				Name: pulumi.String("AV36"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.PrivateCloud;
 * import com.pulumi.azurenative.avs.PrivateCloudArgs;
 * import com.pulumi.azurenative.avs.inputs.AvailabilityPropertiesArgs;
 * import com.pulumi.azurenative.avs.inputs.ManagementClusterArgs;
 * import com.pulumi.azurenative.avs.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateCloud = new PrivateCloud("privateCloud", PrivateCloudArgs.builder()
 *             .availability(AvailabilityPropertiesArgs.builder()
 *                 .secondaryZone(2)
 *                 .strategy("DualZone")
 *                 .zone(1)
 *                 .build())
 *             .location("eastus2")
 *             .managementCluster(ManagementClusterArgs.builder()
 *                 .clusterSize(4)
 *                 .build())
 *             .networkBlock("192.168.48.0/22")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .sku(SkuArgs.builder()
 *                 .name("AV36")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:PrivateCloud cloud1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}
 * ```
 * @property availability Properties describing how the cloud is distributed across availability zones
 * @property encryption Customer managed key encryption, can be enabled or disabled
 * @property identity The identity of the private cloud, if configured.
 * @property identitySources vCenter Single Sign On Identity Sources
 * @property internet Connectivity to internet is enabled or disabled
 * @property location Resource location
 * @property managementCluster The default cluster used for management
 * @property networkBlock The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
 * @property nsxtPassword Optionally, set the NSX-T Manager password when the private cloud is created
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The private cloud SKU
 * @property tags Resource tags
 * @property vcenterPassword Optionally, set the vCenter admin password when the private cloud is created
 */
public data class PrivateCloudArgs(
    public val availability: Output<AvailabilityPropertiesArgs>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val identity: Output<PrivateCloudIdentityArgs>? = null,
    public val identitySources: Output<List<IdentitySourceArgs>>? = null,
    public val internet: Output<Either<String, InternetEnum>>? = null,
    public val location: Output<String>? = null,
    public val managementCluster: Output<ManagementClusterArgs>? = null,
    public val networkBlock: Output<String>? = null,
    public val nsxtPassword: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vcenterPassword: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.PrivateCloudArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.PrivateCloudArgs =
        com.pulumi.azurenative.avs.PrivateCloudArgs.builder()
            .availability(availability?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identitySources(
                identitySources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .internet(
                internet?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managementCluster(managementCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkBlock(networkBlock?.applyValue({ args0 -> args0 }))
            .nsxtPassword(nsxtPassword?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vcenterPassword(vcenterPassword?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateCloudArgs].
 */
@PulumiTagMarker
public class PrivateCloudArgsBuilder internal constructor() {
    private var availability: Output<AvailabilityPropertiesArgs>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var identity: Output<PrivateCloudIdentityArgs>? = null

    private var identitySources: Output<List<IdentitySourceArgs>>? = null

    private var internet: Output<Either<String, InternetEnum>>? = null

    private var location: Output<String>? = null

    private var managementCluster: Output<ManagementClusterArgs>? = null

    private var networkBlock: Output<String>? = null

    private var nsxtPassword: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vcenterPassword: Output<String>? = null

    /**
     * @param value Properties describing how the cloud is distributed across availability zones
     */
    @JvmName("pwnllhybeplrjhye")
    public suspend fun availability(`value`: Output<AvailabilityPropertiesArgs>) {
        this.availability = value
    }

    /**
     * @param value Customer managed key encryption, can be enabled or disabled
     */
    @JvmName("eqpkedyujqggnijy")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The identity of the private cloud, if configured.
     */
    @JvmName("rqvxrfjdpuekhpny")
    public suspend fun identity(`value`: Output<PrivateCloudIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value vCenter Single Sign On Identity Sources
     */
    @JvmName("hyawiyaqjbpkmaps")
    public suspend fun identitySources(`value`: Output<List<IdentitySourceArgs>>) {
        this.identitySources = value
    }

    @JvmName("mjfsiqeiqyitwwti")
    public suspend fun identitySources(vararg values: Output<IdentitySourceArgs>) {
        this.identitySources = Output.all(values.asList())
    }

    /**
     * @param values vCenter Single Sign On Identity Sources
     */
    @JvmName("qucabstnwfcqxwns")
    public suspend fun identitySources(values: List<Output<IdentitySourceArgs>>) {
        this.identitySources = Output.all(values)
    }

    /**
     * @param value Connectivity to internet is enabled or disabled
     */
    @JvmName("sikpuupxgowekykc")
    public suspend fun internet(`value`: Output<Either<String, InternetEnum>>) {
        this.internet = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("cnahhsweyvdlscem")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The default cluster used for management
     */
    @JvmName("mouufgallaccvoth")
    public suspend fun managementCluster(`value`: Output<ManagementClusterArgs>) {
        this.managementCluster = value
    }

    /**
     * @param value The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
     */
    @JvmName("jenxcvjjnpycqblj")
    public suspend fun networkBlock(`value`: Output<String>) {
        this.networkBlock = value
    }

    /**
     * @param value Optionally, set the NSX-T Manager password when the private cloud is created
     */
    @JvmName("vunmsrudhvxsbwlo")
    public suspend fun nsxtPassword(`value`: Output<String>) {
        this.nsxtPassword = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("skktojmkdwpysjaa")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("toubjiixedgjkhsi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The private cloud SKU
     */
    @JvmName("hqfnwfwbfphrwmyc")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("wmiodokbpqcpypje")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Optionally, set the vCenter admin password when the private cloud is created
     */
    @JvmName("ckyunjmfduotvwdf")
    public suspend fun vcenterPassword(`value`: Output<String>) {
        this.vcenterPassword = value
    }

    /**
     * @param value Properties describing how the cloud is distributed across availability zones
     */
    @JvmName("rbevfgkjcdhrhutr")
    public suspend fun availability(`value`: AvailabilityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availability = mapped
    }

    /**
     * @param argument Properties describing how the cloud is distributed across availability zones
     */
    @JvmName("ucxuommhcmosbdnn")
    public suspend fun availability(argument: suspend AvailabilityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AvailabilityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.availability = mapped
    }

    /**
     * @param value Customer managed key encryption, can be enabled or disabled
     */
    @JvmName("ivxgsiussinupgkr")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Customer managed key encryption, can be enabled or disabled
     */
    @JvmName("uasnauloybvhkuyk")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The identity of the private cloud, if configured.
     */
    @JvmName("cagqdaafhqkaixjv")
    public suspend fun identity(`value`: PrivateCloudIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the private cloud, if configured.
     */
    @JvmName("swvkoqrmspdtdiat")
    public suspend fun identity(argument: suspend PrivateCloudIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateCloudIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value vCenter Single Sign On Identity Sources
     */
    @JvmName("ulbwyrnvsdjaqdmk")
    public suspend fun identitySources(`value`: List<IdentitySourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identitySources = mapped
    }

    /**
     * @param argument vCenter Single Sign On Identity Sources
     */
    @JvmName("aiiveuibhsglqeun")
    public suspend fun identitySources(argument: List<suspend IdentitySourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IdentitySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identitySources = mapped
    }

    /**
     * @param argument vCenter Single Sign On Identity Sources
     */
    @JvmName("jojjnbltuxqycvpx")
    public suspend fun identitySources(
        vararg
        argument: suspend IdentitySourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IdentitySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identitySources = mapped
    }

    /**
     * @param argument vCenter Single Sign On Identity Sources
     */
    @JvmName("lpqiootsdfoumshg")
    public suspend fun identitySources(argument: suspend IdentitySourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IdentitySourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.identitySources = mapped
    }

    /**
     * @param values vCenter Single Sign On Identity Sources
     */
    @JvmName("blnkvropvdhcptjr")
    public suspend fun identitySources(vararg values: IdentitySourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identitySources = mapped
    }

    /**
     * @param value Connectivity to internet is enabled or disabled
     */
    @JvmName("qpjacrbrijvwacan")
    public suspend fun internet(`value`: Either<String, InternetEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internet = mapped
    }

    /**
     * @param value Connectivity to internet is enabled or disabled
     */
    @JvmName("yurhorjllsvlsiaa")
    public fun internet(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InternetEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internet = mapped
    }

    /**
     * @param value Connectivity to internet is enabled or disabled
     */
    @JvmName("aamnwpomhlfpwetc")
    public fun internet(`value`: InternetEnum) {
        val toBeMapped = Either.ofRight<String, InternetEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internet = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("wspfmccphdkfefdv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The default cluster used for management
     */
    @JvmName("citetilnotgdccqc")
    public suspend fun managementCluster(`value`: ManagementClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementCluster = mapped
    }

    /**
     * @param argument The default cluster used for management
     */
    @JvmName("bijltvqlmwtrmufd")
    public suspend fun managementCluster(argument: suspend ManagementClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementClusterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementCluster = mapped
    }

    /**
     * @param value The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
     */
    @JvmName("thkenvitsqonqxog")
    public suspend fun networkBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBlock = mapped
    }

    /**
     * @param value Optionally, set the NSX-T Manager password when the private cloud is created
     */
    @JvmName("oprgtwacaiyhdsks")
    public suspend fun nsxtPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nsxtPassword = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("atayysvasnhxvful")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ghljrmnpcldkjplk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The private cloud SKU
     */
    @JvmName("xpnnyirutypfkbob")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The private cloud SKU
     */
    @JvmName("ufbbopngjffumgmc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("uwxheyvhbbauahxy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("rklwriplmahbiuxh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Optionally, set the vCenter admin password when the private cloud is created
     */
    @JvmName("vhgdkftwvofbygpl")
    public suspend fun vcenterPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcenterPassword = mapped
    }

    internal fun build(): PrivateCloudArgs = PrivateCloudArgs(
        availability = availability,
        encryption = encryption,
        identity = identity,
        identitySources = identitySources,
        internet = internet,
        location = location,
        managementCluster = managementCluster,
        networkBlock = networkBlock,
        nsxtPassword = nsxtPassword,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        vcenterPassword = vcenterPassword,
    )
}
