@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.ScriptExecutionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An instance of a script executed by a user - custom or AVS
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### ScriptExecutions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scriptExecution = new AzureNative.AVS.ScriptExecution("scriptExecution", new()
 *     {
 *         HiddenParameters = new[]
 *         {
 *             new AzureNative.AVS.Inputs.ScriptSecureStringExecutionParameterArgs
 *             {
 *                 Name = "Password",
 *                 SecureValue = "PlaceholderPassword",
 *                 Type = "SecureValue",
 *             },
 *         },
 *         Parameters = new[]
 *         {
 *             new AzureNative.AVS.Inputs.ScriptStringExecutionParameterArgs
 *             {
 *                 Name = "DomainName",
 *                 Type = "Value",
 *                 Value = "placeholderDomain.local",
 *             },
 *             new AzureNative.AVS.Inputs.ScriptStringExecutionParameterArgs
 *             {
 *                 Name = "BaseUserDN",
 *                 Type = "Value",
 *                 Value = "DC=placeholder, DC=placeholder",
 *             },
 *         },
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Retention = "P0Y0M60DT0H60M60S",
 *         ScriptCmdletId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource",
 *         ScriptExecutionName = "addSsoServer",
 *         Timeout = "P0Y0M0DT0H60M60S",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewScriptExecution(ctx, "scriptExecution", &avs.ScriptExecutionArgs{
 * 			HiddenParameters: pulumi.Array{
 * 				avs.ScriptSecureStringExecutionParameter{
 * 					Name:        "Password",
 * 					SecureValue: "PlaceholderPassword",
 * 					Type:        "SecureValue",
 * 				},
 * 			},
 * 			Parameters: pulumi.Array{
 * 				avs.ScriptStringExecutionParameter{
 * 					Name:  "DomainName",
 * 					Type:  "Value",
 * 					Value: "placeholderDomain.local",
 * 				},
 * 				avs.ScriptStringExecutionParameter{
 * 					Name:  "BaseUserDN",
 * 					Type:  "Value",
 * 					Value: "DC=placeholder, DC=placeholder",
 * 				},
 * 			},
 * 			PrivateCloudName:    pulumi.String("cloud1"),
 * 			ResourceGroupName:   pulumi.String("group1"),
 * 			Retention:           pulumi.String("P0Y0M60DT0H60M60S"),
 * 			ScriptCmdletId:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
 * 			ScriptExecutionName: pulumi.String("addSsoServer"),
 * 			Timeout:             pulumi.String("P0Y0M0DT0H60M60S"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.ScriptExecution;
 * import com.pulumi.azurenative.avs.ScriptExecutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scriptExecution = new ScriptExecution("scriptExecution", ScriptExecutionArgs.builder()
 *             .hiddenParameters(PSCredentialExecutionParameterArgs.builder()
 *                 .name("Password")
 *                 .secureValue("PlaceholderPassword")
 *                 .type("SecureValue")
 *                 .build())
 *             .parameters(
 *                 PSCredentialExecutionParameterArgs.builder()
 *                     .name("DomainName")
 *                     .type("Value")
 *                     .value("placeholderDomain.local")
 *                     .build(),
 *                 PSCredentialExecutionParameterArgs.builder()
 *                     .name("BaseUserDN")
 *                     .type("Value")
 *                     .value("DC=placeholder, DC=placeholder")
 *                     .build())
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .retention("P0Y0M60DT0H60M60S")
 *             .scriptCmdletId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource")
 *             .scriptExecutionName("addSsoServer")
 *             .timeout("P0Y0M0DT0H60M60S")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:ScriptExecution addSsoServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/scriptExecutions/{scriptExecutionName}
 * ```
 * @property failureReason Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
 * @property hiddenParameters Parameters that will be hidden/not visible to ARM, such as passwords and credentials
 * @property namedOutputs User-defined dictionary.
 * @property output Standard output stream from the powershell execution
 * @property parameters Parameters the script will accept
 * @property privateCloudName The name of the private cloud.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property retention Time to live for the resource. If not provided, will be available for 60 days
 * @property scriptCmdletId A reference to the script cmdlet resource if user is running a AVS script
 * @property scriptExecutionName Name of the user-invoked script execution resource
 * @property timeout Time limit for execution
 */
public data class ScriptExecutionArgs(
    public val failureReason: Output<String>? = null,
    public val hiddenParameters: Output<List<Any>>? = null,
    public val namedOutputs: Output<Map<String, Any>>? = null,
    public val output: Output<List<String>>? = null,
    public val parameters: Output<List<Any>>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retention: Output<String>? = null,
    public val scriptCmdletId: Output<String>? = null,
    public val scriptExecutionName: Output<String>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.ScriptExecutionArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.ScriptExecutionArgs =
        com.pulumi.azurenative.avs.ScriptExecutionArgs.builder()
            .failureReason(failureReason?.applyValue({ args0 -> args0 }))
            .hiddenParameters(hiddenParameters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .namedOutputs(
                namedOutputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .output(output?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parameters(parameters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retention(retention?.applyValue({ args0 -> args0 }))
            .scriptCmdletId(scriptCmdletId?.applyValue({ args0 -> args0 }))
            .scriptExecutionName(scriptExecutionName?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptExecutionArgs].
 */
@PulumiTagMarker
public class ScriptExecutionArgsBuilder internal constructor() {
    private var failureReason: Output<String>? = null

    private var hiddenParameters: Output<List<Any>>? = null

    private var namedOutputs: Output<Map<String, Any>>? = null

    private var output: Output<List<String>>? = null

    private var parameters: Output<List<Any>>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retention: Output<String>? = null

    private var scriptCmdletId: Output<String>? = null

    private var scriptExecutionName: Output<String>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
     */
    @JvmName("jmklppwwlawpbvwv")
    public suspend fun failureReason(`value`: Output<String>) {
        this.failureReason = value
    }

    /**
     * @param value Parameters that will be hidden/not visible to ARM, such as passwords and credentials
     */
    @JvmName("tlmghceaouwkcncl")
    public suspend fun hiddenParameters(`value`: Output<List<Any>>) {
        this.hiddenParameters = value
    }

    @JvmName("xhkwrnxoaxbmbeqs")
    public suspend fun hiddenParameters(vararg values: Output<Any>) {
        this.hiddenParameters = Output.all(values.asList())
    }

    /**
     * @param values Parameters that will be hidden/not visible to ARM, such as passwords and credentials
     */
    @JvmName("hssajneihtuwsnve")
    public suspend fun hiddenParameters(values: List<Output<Any>>) {
        this.hiddenParameters = Output.all(values)
    }

    /**
     * @param value User-defined dictionary.
     */
    @JvmName("lldnspievadwdyxs")
    public suspend fun namedOutputs(`value`: Output<Map<String, Any>>) {
        this.namedOutputs = value
    }

    /**
     * @param value Standard output stream from the powershell execution
     */
    @JvmName("ocbbghxsvqfbuiek")
    public suspend fun output(`value`: Output<List<String>>) {
        this.output = value
    }

    @JvmName("bisobteocnsikvey")
    public suspend fun output(vararg values: Output<String>) {
        this.output = Output.all(values.asList())
    }

    /**
     * @param values Standard output stream from the powershell execution
     */
    @JvmName("ytqabmfbuvfpcsol")
    public suspend fun output(values: List<Output<String>>) {
        this.output = Output.all(values)
    }

    /**
     * @param value Parameters the script will accept
     */
    @JvmName("vxnkitvktsynjcde")
    public suspend fun parameters(`value`: Output<List<Any>>) {
        this.parameters = value
    }

    @JvmName("fpyjqfchcmicegna")
    public suspend fun parameters(vararg values: Output<Any>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Parameters the script will accept
     */
    @JvmName("mfaaffirbdgvnifm")
    public suspend fun parameters(values: List<Output<Any>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("sjatdvuxgiijkdle")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("apwiofecunshvido")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Time to live for the resource. If not provided, will be available for 60 days
     */
    @JvmName("xsphjttcjbgddxjh")
    public suspend fun retention(`value`: Output<String>) {
        this.retention = value
    }

    /**
     * @param value A reference to the script cmdlet resource if user is running a AVS script
     */
    @JvmName("aujwutujegibsyjj")
    public suspend fun scriptCmdletId(`value`: Output<String>) {
        this.scriptCmdletId = value
    }

    /**
     * @param value Name of the user-invoked script execution resource
     */
    @JvmName("kigcyflvjbjojnko")
    public suspend fun scriptExecutionName(`value`: Output<String>) {
        this.scriptExecutionName = value
    }

    /**
     * @param value Time limit for execution
     */
    @JvmName("cwhvxhvyrbuyeyix")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
     */
    @JvmName("dnqdbifrufgeestv")
    public suspend fun failureReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureReason = mapped
    }

    /**
     * @param value Parameters that will be hidden/not visible to ARM, such as passwords and credentials
     */
    @JvmName("swijiikneflcowvg")
    public suspend fun hiddenParameters(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiddenParameters = mapped
    }

    /**
     * @param values Parameters that will be hidden/not visible to ARM, such as passwords and credentials
     */
    @JvmName("oyvyjoqvjvuaxutx")
    public suspend fun hiddenParameters(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hiddenParameters = mapped
    }

    /**
     * @param value User-defined dictionary.
     */
    @JvmName("dkbnkfldvgtwtpmk")
    public suspend fun namedOutputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namedOutputs = mapped
    }

    /**
     * @param values User-defined dictionary.
     */
    @JvmName("pebqypkxdlauvaex")
    public fun namedOutputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namedOutputs = mapped
    }

    /**
     * @param value Standard output stream from the powershell execution
     */
    @JvmName("savoagyevaayenno")
    public suspend fun output(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.output = mapped
    }

    /**
     * @param values Standard output stream from the powershell execution
     */
    @JvmName("bqasaublweqrkftb")
    public suspend fun output(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.output = mapped
    }

    /**
     * @param value Parameters the script will accept
     */
    @JvmName("jdthtdadfpdclfli")
    public suspend fun parameters(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Parameters the script will accept
     */
    @JvmName("rhmllqabqedlduak")
    public suspend fun parameters(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("ttgdxflyabymgqpk")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nnyonyllovxtskeb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Time to live for the resource. If not provided, will be available for 60 days
     */
    @JvmName("hhxuuvkmhmuqocna")
    public suspend fun retention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value A reference to the script cmdlet resource if user is running a AVS script
     */
    @JvmName("xuwafhevbmagckvo")
    public suspend fun scriptCmdletId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptCmdletId = mapped
    }

    /**
     * @param value Name of the user-invoked script execution resource
     */
    @JvmName("tkjdwqpbgpssahkf")
    public suspend fun scriptExecutionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptExecutionName = mapped
    }

    /**
     * @param value Time limit for execution
     */
    @JvmName("umkxidoricehocqh")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ScriptExecutionArgs = ScriptExecutionArgs(
        failureReason = failureReason,
        hiddenParameters = hiddenParameters,
        namedOutputs = namedOutputs,
        output = output,
        parameters = parameters,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        retention = retention,
        scriptCmdletId = scriptCmdletId,
        scriptExecutionName = scriptExecutionName,
        timeout = timeout,
    )
}
