@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WorkloadNetworkDnsService].
 */
@PulumiTagMarker
public class WorkloadNetworkDnsServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkDnsServiceArgs = WorkloadNetworkDnsServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkDnsServiceArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkDnsServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadNetworkDnsService {
        val builtJavaResource =
            com.pulumi.azurenative.avs.WorkloadNetworkDnsService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadNetworkDnsService(builtJavaResource)
    }
}

/**
 * NSX DNS Service
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateDnsService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkDnsService = new AzureNative.AVS.WorkloadNetworkDnsService("workloadNetworkDnsService", new()
 *     {
 *         DefaultDnsZone = "defaultDnsZone1",
 *         DisplayName = "dnsService1",
 *         DnsServiceId = "dnsService1",
 *         DnsServiceIp = "5.5.5.5",
 *         FqdnZones = new[]
 *         {
 *             "fqdnZone1",
 *         },
 *         LogLevel = AzureNative.AVS.DnsServiceLogLevelEnum.INFO,
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkDnsService(ctx, "workloadNetworkDnsService", &avs.WorkloadNetworkDnsServiceArgs{
 * 			DefaultDnsZone: pulumi.String("defaultDnsZone1"),
 * 			DisplayName:    pulumi.String("dnsService1"),
 * 			DnsServiceId:   pulumi.String("dnsService1"),
 * 			DnsServiceIp:   pulumi.String("5.5.5.5"),
 * 			FqdnZones: pulumi.StringArray{
 * 				pulumi.String("fqdnZone1"),
 * 			},
 * 			LogLevel:          pulumi.String(avs.DnsServiceLogLevelEnumINFO),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsService;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkDnsService = new WorkloadNetworkDnsService("workloadNetworkDnsService", WorkloadNetworkDnsServiceArgs.builder()
 *             .defaultDnsZone("defaultDnsZone1")
 *             .displayName("dnsService1")
 *             .dnsServiceId("dnsService1")
 *             .dnsServiceIp("5.5.5.5")
 *             .fqdnZones("fqdnZone1")
 *             .logLevel("INFO")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkDnsService dnsService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices/{dnsServiceId}
 * ```
 */
public class WorkloadNetworkDnsService internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkDnsService,
) : KotlinCustomResource(javaResource, WorkloadNetworkDnsServiceMapper) {
    /**
     * Default DNS zone of the DNS Service.
     */
    public val defaultDnsZone: Output<String>?
        get() = javaResource.defaultDnsZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the DNS Service.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DNS service IP of the DNS Service.
     */
    public val dnsServiceIp: Output<String>?
        get() = javaResource.dnsServiceIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * FQDN zones of the DNS Service.
     */
    public val fqdnZones: Output<List<String>>?
        get() = javaResource.fqdnZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * DNS Service log level.
     */
    public val logLevel: Output<String>?
        get() = javaResource.logLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * NSX revision number.
     */
    public val revision: Output<Double>?
        get() = javaResource.revision().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * DNS Service status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkDnsServiceMapper : ResourceMapper<WorkloadNetworkDnsService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkDnsService::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkDnsService =
        WorkloadNetworkDnsService(
            javaResource as
                com.pulumi.azurenative.avs.WorkloadNetworkDnsService,
        )
}

/**
 * @see [WorkloadNetworkDnsService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkDnsService].
 */
public suspend fun workloadNetworkDnsService(
    name: String,
    block: suspend WorkloadNetworkDnsServiceResourceBuilder.() -> Unit,
): WorkloadNetworkDnsService {
    val builder = WorkloadNetworkDnsServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkDnsService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkDnsService(name: String): WorkloadNetworkDnsService {
    val builder = WorkloadNetworkDnsServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
