@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkDnsServiceArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.DnsServiceLogLevelEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NSX DNS Service
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateDnsService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkDnsService = new AzureNative.AVS.WorkloadNetworkDnsService("workloadNetworkDnsService", new()
 *     {
 *         DefaultDnsZone = "defaultDnsZone1",
 *         DisplayName = "dnsService1",
 *         DnsServiceId = "dnsService1",
 *         DnsServiceIp = "5.5.5.5",
 *         FqdnZones = new[]
 *         {
 *             "fqdnZone1",
 *         },
 *         LogLevel = AzureNative.AVS.DnsServiceLogLevelEnum.INFO,
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkDnsService(ctx, "workloadNetworkDnsService", &avs.WorkloadNetworkDnsServiceArgs{
 * 			DefaultDnsZone: pulumi.String("defaultDnsZone1"),
 * 			DisplayName:    pulumi.String("dnsService1"),
 * 			DnsServiceId:   pulumi.String("dnsService1"),
 * 			DnsServiceIp:   pulumi.String("5.5.5.5"),
 * 			FqdnZones: pulumi.StringArray{
 * 				pulumi.String("fqdnZone1"),
 * 			},
 * 			LogLevel:          pulumi.String(avs.DnsServiceLogLevelEnumINFO),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsService;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkDnsService = new WorkloadNetworkDnsService("workloadNetworkDnsService", WorkloadNetworkDnsServiceArgs.builder()
 *             .defaultDnsZone("defaultDnsZone1")
 *             .displayName("dnsService1")
 *             .dnsServiceId("dnsService1")
 *             .dnsServiceIp("5.5.5.5")
 *             .fqdnZones("fqdnZone1")
 *             .logLevel("INFO")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkDnsService dnsService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices/{dnsServiceId}
 * ```
 * @property defaultDnsZone Default DNS zone of the DNS Service.
 * @property displayName Display name of the DNS Service.
 * @property dnsServiceId NSX DNS Service identifier. Generally the same as the DNS Service's display name
 * @property dnsServiceIp DNS service IP of the DNS Service.
 * @property fqdnZones FQDN zones of the DNS Service.
 * @property logLevel DNS Service log level.
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property revision NSX revision number.
 */
public data class WorkloadNetworkDnsServiceArgs(
    public val defaultDnsZone: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val dnsServiceId: Output<String>? = null,
    public val dnsServiceIp: Output<String>? = null,
    public val fqdnZones: Output<List<String>>? = null,
    public val logLevel: Output<Either<String, DnsServiceLogLevelEnum>>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val revision: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkDnsServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkDnsServiceArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkDnsServiceArgs.builder()
            .defaultDnsZone(defaultDnsZone?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .dnsServiceId(dnsServiceId?.applyValue({ args0 -> args0 }))
            .dnsServiceIp(dnsServiceIp?.applyValue({ args0 -> args0 }))
            .fqdnZones(fqdnZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .logLevel(
                logLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkDnsServiceArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkDnsServiceArgsBuilder internal constructor() {
    private var defaultDnsZone: Output<String>? = null

    private var displayName: Output<String>? = null

    private var dnsServiceId: Output<String>? = null

    private var dnsServiceIp: Output<String>? = null

    private var fqdnZones: Output<List<String>>? = null

    private var logLevel: Output<Either<String, DnsServiceLogLevelEnum>>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var revision: Output<Double>? = null

    /**
     * @param value Default DNS zone of the DNS Service.
     */
    @JvmName("cmomeocvjkjdtbas")
    public suspend fun defaultDnsZone(`value`: Output<String>) {
        this.defaultDnsZone = value
    }

    /**
     * @param value Display name of the DNS Service.
     */
    @JvmName("clnxmvxlfanjopmk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value NSX DNS Service identifier. Generally the same as the DNS Service's display name
     */
    @JvmName("kwbvsqavqkglbkfv")
    public suspend fun dnsServiceId(`value`: Output<String>) {
        this.dnsServiceId = value
    }

    /**
     * @param value DNS service IP of the DNS Service.
     */
    @JvmName("swcrxfybopefxceq")
    public suspend fun dnsServiceIp(`value`: Output<String>) {
        this.dnsServiceIp = value
    }

    /**
     * @param value FQDN zones of the DNS Service.
     */
    @JvmName("vkpvakogreyicsuj")
    public suspend fun fqdnZones(`value`: Output<List<String>>) {
        this.fqdnZones = value
    }

    @JvmName("dcgoiugfgdiaprvn")
    public suspend fun fqdnZones(vararg values: Output<String>) {
        this.fqdnZones = Output.all(values.asList())
    }

    /**
     * @param values FQDN zones of the DNS Service.
     */
    @JvmName("xmhfbyngjsfqvvah")
    public suspend fun fqdnZones(values: List<Output<String>>) {
        this.fqdnZones = Output.all(values)
    }

    /**
     * @param value DNS Service log level.
     */
    @JvmName("jrwoglrfvstkxbyj")
    public suspend fun logLevel(`value`: Output<Either<String, DnsServiceLogLevelEnum>>) {
        this.logLevel = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("evkajbyaxrkrnkfc")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oefnkqicgjddmljr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("occsuexnkvaxbyvh")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value Default DNS zone of the DNS Service.
     */
    @JvmName("vtkalgowiopsiflu")
    public suspend fun defaultDnsZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDnsZone = mapped
    }

    /**
     * @param value Display name of the DNS Service.
     */
    @JvmName("trjybtcgestagjnv")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value NSX DNS Service identifier. Generally the same as the DNS Service's display name
     */
    @JvmName("wjwbklfhwlbvkvit")
    public suspend fun dnsServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServiceId = mapped
    }

    /**
     * @param value DNS service IP of the DNS Service.
     */
    @JvmName("glojewxupdhpqjox")
    public suspend fun dnsServiceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServiceIp = mapped
    }

    /**
     * @param value FQDN zones of the DNS Service.
     */
    @JvmName("vmafalljhnipaovk")
    public suspend fun fqdnZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnZones = mapped
    }

    /**
     * @param values FQDN zones of the DNS Service.
     */
    @JvmName("njqdpwwvrojpgdpr")
    public suspend fun fqdnZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnZones = mapped
    }

    /**
     * @param value DNS Service log level.
     */
    @JvmName("vabiouhntvmhwhxg")
    public suspend fun logLevel(`value`: Either<String, DnsServiceLogLevelEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value DNS Service log level.
     */
    @JvmName("vplxntpsutobwypu")
    public fun logLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DnsServiceLogLevelEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value DNS Service log level.
     */
    @JvmName("enmoxydkeeusamfx")
    public fun logLevel(`value`: DnsServiceLogLevelEnum) {
        val toBeMapped = Either.ofRight<String, DnsServiceLogLevelEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("bxecmdlynecmocrp")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxrlnfbmturoskcg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("ayeudywfgjdjrpyt")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    internal fun build(): WorkloadNetworkDnsServiceArgs = WorkloadNetworkDnsServiceArgs(
        defaultDnsZone = defaultDnsZone,
        displayName = displayName,
        dnsServiceId = dnsServiceId,
        dnsServiceIp = dnsServiceIp,
        fqdnZones = fqdnZones,
        logLevel = logLevel,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        revision = revision,
    )
}
