@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WorkloadNetworkDnsZone].
 */
@PulumiTagMarker
public class WorkloadNetworkDnsZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkDnsZoneArgs = WorkloadNetworkDnsZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkDnsZoneArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkDnsZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadNetworkDnsZone {
        val builtJavaResource =
            com.pulumi.azurenative.avs.WorkloadNetworkDnsZone(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadNetworkDnsZone(builtJavaResource)
    }
}

/**
 * NSX DNS Zone
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateDnsZone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkDnsZone = new AzureNative.AVS.WorkloadNetworkDnsZone("workloadNetworkDnsZone", new()
 *     {
 *         DisplayName = "dnsZone1",
 *         DnsServerIps = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         DnsZoneId = "dnsZone1",
 *         Domain = new[] {},
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         SourceIp = "8.8.8.8",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkDnsZone(ctx, "workloadNetworkDnsZone", &avs.WorkloadNetworkDnsZoneArgs{
 * 			DisplayName: pulumi.String("dnsZone1"),
 * 			DnsServerIps: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			DnsZoneId:         pulumi.String("dnsZone1"),
 * 			Domain:            pulumi.StringArray{},
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			SourceIp:          pulumi.String("8.8.8.8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsZone;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkDnsZone = new WorkloadNetworkDnsZone("workloadNetworkDnsZone", WorkloadNetworkDnsZoneArgs.builder()
 *             .displayName("dnsZone1")
 *             .dnsServerIps("1.1.1.1")
 *             .dnsZoneId("dnsZone1")
 *             .domain()
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .sourceIp("8.8.8.8")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkDnsZone dnsZone1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones/{dnsZoneId}
 * ```
 */
public class WorkloadNetworkDnsZone internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkDnsZone,
) : KotlinCustomResource(javaResource, WorkloadNetworkDnsZoneMapper) {
    /**
     * Display name of the DNS Zone.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DNS Server IP array of the DNS Zone.
     */
    public val dnsServerIps: Output<List<String>>?
        get() = javaResource.dnsServerIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Number of DNS Services using the DNS zone.
     */
    public val dnsServices: Output<Double>?
        get() = javaResource.dnsServices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain names of the DNS Zone.
     */
    public val domain: Output<List<String>>?
        get() = javaResource.domain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * NSX revision number.
     */
    public val revision: Output<Double>?
        get() = javaResource.revision().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Source IP of the DNS Zone.
     */
    public val sourceIp: Output<String>?
        get() = javaResource.sourceIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkDnsZoneMapper : ResourceMapper<WorkloadNetworkDnsZone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkDnsZone::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkDnsZone =
        WorkloadNetworkDnsZone(javaResource as com.pulumi.azurenative.avs.WorkloadNetworkDnsZone)
}

/**
 * @see [WorkloadNetworkDnsZone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkDnsZone].
 */
public suspend fun workloadNetworkDnsZone(
    name: String,
    block: suspend WorkloadNetworkDnsZoneResourceBuilder.() -> Unit,
): WorkloadNetworkDnsZone {
    val builder = WorkloadNetworkDnsZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkDnsZone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkDnsZone(name: String): WorkloadNetworkDnsZone {
    val builder = WorkloadNetworkDnsZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
