@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkPortMirroringArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.PortMirroringDirectionEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NSX Port Mirroring
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreatePortMirroring
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkPortMirroring = new AzureNative.AVS.WorkloadNetworkPortMirroring("workloadNetworkPortMirroring", new()
 *     {
 *         Destination = "vmGroup2",
 *         Direction = AzureNative.AVS.PortMirroringDirectionEnum.BIDIRECTIONAL,
 *         DisplayName = "portMirroring1",
 *         PortMirroringId = "portMirroring1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         Source = "vmGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkPortMirroring(ctx, "workloadNetworkPortMirroring", &avs.WorkloadNetworkPortMirroringArgs{
 * 			Destination:       pulumi.String("vmGroup2"),
 * 			Direction:         pulumi.String(avs.PortMirroringDirectionEnumBIDIRECTIONAL),
 * 			DisplayName:       pulumi.String("portMirroring1"),
 * 			PortMirroringId:   pulumi.String("portMirroring1"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			Source:            pulumi.String("vmGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPortMirroring;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPortMirroringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkPortMirroring = new WorkloadNetworkPortMirroring("workloadNetworkPortMirroring", WorkloadNetworkPortMirroringArgs.builder()
 *             .destination("vmGroup2")
 *             .direction("BIDIRECTIONAL")
 *             .displayName("portMirroring1")
 *             .portMirroringId("portMirroring1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .source("vmGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkPortMirroring portMirroring1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles/{portMirroringId}
 * ```
 * @property destination Destination VM Group.
 * @property direction Direction of port mirroring profile.
 * @property displayName Display name of the port mirroring profile.
 * @property portMirroringId NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property revision NSX revision number.
 * @property source Source VM Group.
 */
public data class WorkloadNetworkPortMirroringArgs(
    public val destination: Output<String>? = null,
    public val direction: Output<Either<String, PortMirroringDirectionEnum>>? = null,
    public val displayName: Output<String>? = null,
    public val portMirroringId: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val revision: Output<Double>? = null,
    public val source: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkPortMirroringArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkPortMirroringArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkPortMirroringArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .portMirroringId(portMirroringId?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkPortMirroringArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkPortMirroringArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var direction: Output<Either<String, PortMirroringDirectionEnum>>? = null

    private var displayName: Output<String>? = null

    private var portMirroringId: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var revision: Output<Double>? = null

    private var source: Output<String>? = null

    /**
     * @param value Destination VM Group.
     */
    @JvmName("dbivrbhxcxbyqpfa")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Direction of port mirroring profile.
     */
    @JvmName("kqvbwuvjjtvlmyxv")
    public suspend fun direction(`value`: Output<Either<String, PortMirroringDirectionEnum>>) {
        this.direction = value
    }

    /**
     * @param value Display name of the port mirroring profile.
     */
    @JvmName("hdhupphdbnigoypu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
     */
    @JvmName("vbxhkyofirqfhsgi")
    public suspend fun portMirroringId(`value`: Output<String>) {
        this.portMirroringId = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("lhhcjodadlacssjw")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ymrerjchpoxcmrgp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("qyrmwiatgcocrvon")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value Source VM Group.
     */
    @JvmName("lvpgnvrepxaflqdc")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Destination VM Group.
     */
    @JvmName("scnbfmymflpmqqea")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Direction of port mirroring profile.
     */
    @JvmName("kxxxthhakwyxsxvv")
    public suspend fun direction(`value`: Either<String, PortMirroringDirectionEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of port mirroring profile.
     */
    @JvmName("erjrjlyaiwwatjqg")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PortMirroringDirectionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of port mirroring profile.
     */
    @JvmName("ajkokybhmibgsybb")
    public fun direction(`value`: PortMirroringDirectionEnum) {
        val toBeMapped = Either.ofRight<String, PortMirroringDirectionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Display name of the port mirroring profile.
     */
    @JvmName("nyjbvobkbrcfoqmm")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
     */
    @JvmName("jqlgcswxifnlljpp")
    public suspend fun portMirroringId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portMirroringId = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("ngeehednayccqaso")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("heycbloniknxlmts")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("tknosuhrwcoboxkb")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value Source VM Group.
     */
    @JvmName("olyrqlduheuxswbx")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): WorkloadNetworkPortMirroringArgs = WorkloadNetworkPortMirroringArgs(
        destination = destination,
        direction = direction,
        displayName = displayName,
        portMirroringId = portMirroringId,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        revision = revision,
        source = source,
    )
}
