@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WorkloadNetworkVMGroup].
 */
@PulumiTagMarker
public class WorkloadNetworkVMGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkVMGroupArgs = WorkloadNetworkVMGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkVMGroupArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkVMGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadNetworkVMGroup {
        val builtJavaResource =
            com.pulumi.azurenative.avs.WorkloadNetworkVMGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadNetworkVMGroup(builtJavaResource)
    }
}

/**
 * NSX VM Group
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateVMGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkVMGroup = new AzureNative.AVS.WorkloadNetworkVMGroup("workloadNetworkVMGroup", new()
 *     {
 *         DisplayName = "vmGroup1",
 *         Members = new[]
 *         {
 *             "564d43da-fefc-2a3b-1d92-42855622fa50",
 *         },
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         VmGroupId = "vmGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkVMGroup(ctx, "workloadNetworkVMGroup", &avs.WorkloadNetworkVMGroupArgs{
 * 			DisplayName: pulumi.String("vmGroup1"),
 * 			Members: pulumi.StringArray{
 * 				pulumi.String("564d43da-fefc-2a3b-1d92-42855622fa50"),
 * 			},
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			VmGroupId:         pulumi.String("vmGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkVMGroup;
 * import com.pulumi.azurenative.avs.WorkloadNetworkVMGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkVMGroup = new WorkloadNetworkVMGroup("workloadNetworkVMGroup", WorkloadNetworkVMGroupArgs.builder()
 *             .displayName("vmGroup1")
 *             .members("564d43da-fefc-2a3b-1d92-42855622fa50")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .vmGroupId("vmGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkVMGroup vmGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups/{vmGroupId}
 * ```
 */
public class WorkloadNetworkVMGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkVMGroup,
) : KotlinCustomResource(javaResource, WorkloadNetworkVMGroupMapper) {
    /**
     * Display name of the VM group.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Virtual machine members of this group.
     */
    public val members: Output<List<String>>?
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * NSX revision number.
     */
    public val revision: Output<Double>?
        get() = javaResource.revision().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * VM Group status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkVMGroupMapper : ResourceMapper<WorkloadNetworkVMGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkVMGroup::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkVMGroup =
        WorkloadNetworkVMGroup(javaResource as com.pulumi.azurenative.avs.WorkloadNetworkVMGroup)
}

/**
 * @see [WorkloadNetworkVMGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkVMGroup].
 */
public suspend fun workloadNetworkVMGroup(
    name: String,
    block: suspend WorkloadNetworkVMGroupResourceBuilder.() -> Unit,
): WorkloadNetworkVMGroup {
    val builder = WorkloadNetworkVMGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkVMGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkVMGroup(name: String): WorkloadNetworkVMGroup {
    val builder = WorkloadNetworkVMGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
