@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkVMGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NSX VM Group
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01, 2023-09-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateVMGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkVMGroup = new AzureNative.AVS.WorkloadNetworkVMGroup("workloadNetworkVMGroup", new()
 *     {
 *         DisplayName = "vmGroup1",
 *         Members = new[]
 *         {
 *             "564d43da-fefc-2a3b-1d92-42855622fa50",
 *         },
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         VmGroupId = "vmGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkVMGroup(ctx, "workloadNetworkVMGroup", &avs.WorkloadNetworkVMGroupArgs{
 * 			DisplayName: pulumi.String("vmGroup1"),
 * 			Members: pulumi.StringArray{
 * 				pulumi.String("564d43da-fefc-2a3b-1d92-42855622fa50"),
 * 			},
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			VmGroupId:         pulumi.String("vmGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkVMGroup;
 * import com.pulumi.azurenative.avs.WorkloadNetworkVMGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkVMGroup = new WorkloadNetworkVMGroup("workloadNetworkVMGroup", WorkloadNetworkVMGroupArgs.builder()
 *             .displayName("vmGroup1")
 *             .members("564d43da-fefc-2a3b-1d92-42855622fa50")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .vmGroupId("vmGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkVMGroup vmGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups/{vmGroupId}
 * ```
 * @property displayName Display name of the VM group.
 * @property members Virtual machine members of this group.
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property revision NSX revision number.
 * @property vmGroupId NSX VM Group identifier. Generally the same as the VM Group's display name
 */
public data class WorkloadNetworkVMGroupArgs(
    public val displayName: Output<String>? = null,
    public val members: Output<List<String>>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val revision: Output<Double>? = null,
    public val vmGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkVMGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkVMGroupArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkVMGroupArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .members(members?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .vmGroupId(vmGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkVMGroupArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkVMGroupArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var members: Output<List<String>>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var revision: Output<Double>? = null

    private var vmGroupId: Output<String>? = null

    /**
     * @param value Display name of the VM group.
     */
    @JvmName("jdamxnbwjfobaumt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Virtual machine members of this group.
     */
    @JvmName("ntkotjymyyiwkgmd")
    public suspend fun members(`value`: Output<List<String>>) {
        this.members = value
    }

    @JvmName("pyiradeupdfhrafu")
    public suspend fun members(vararg values: Output<String>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values Virtual machine members of this group.
     */
    @JvmName("elqlpxdljiklhwys")
    public suspend fun members(values: List<Output<String>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("fkiduftlymxduqof")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvjwkhiwugonuwny")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("tqhqhblnrepaaduq")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value NSX VM Group identifier. Generally the same as the VM Group's display name
     */
    @JvmName("bogxydndhtafpror")
    public suspend fun vmGroupId(`value`: Output<String>) {
        this.vmGroupId = value
    }

    /**
     * @param value Display name of the VM group.
     */
    @JvmName("cpbeuijxokbdnomo")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Virtual machine members of this group.
     */
    @JvmName("xpefaeuwhqedufsk")
    public suspend fun members(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param values Virtual machine members of this group.
     */
    @JvmName("gsgqxldqsopcclio")
    public suspend fun members(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("uowryabitnwklmma")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxtsbsteuwrkgsvm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("xeyprjyhgqshgwwo")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value NSX VM Group identifier. Generally the same as the VM Group's display name
     */
    @JvmName("guffavelvapbvmbh")
    public suspend fun vmGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmGroupId = mapped
    }

    internal fun build(): WorkloadNetworkVMGroupArgs = WorkloadNetworkVMGroupArgs(
        displayName = displayName,
        members = members,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        revision = revision,
        vmGroupId = vmGroupId,
    )
}
