@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protect LDAP communication using SSL certificate (LDAPS)
 */
public enum class SslEnum(
    public val javaValue: com.pulumi.azurenative.avs.enums.SslEnum,
) : ConvertibleToJava<com.pulumi.azurenative.avs.enums.SslEnum> {
    Enabled(com.pulumi.azurenative.avs.enums.SslEnum.Enabled),
    Disabled(com.pulumi.azurenative.avs.enums.SslEnum.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.avs.enums.SslEnum = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.enums.SslEnum): SslEnum =
            SslEnum.values().first { it.javaValue == javaType }
    }
}
