@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.AddonHcxPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of an HCX addon
 * @property addonType The type of private cloud addon
 * Expected value is 'HCX'.
 * @property offer The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
 */
public data class AddonHcxPropertiesArgs(
    public val addonType: Output<String>,
    public val offer: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.AddonHcxPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.AddonHcxPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.AddonHcxPropertiesArgs.builder()
            .addonType(addonType.applyValue({ args0 -> args0 }))
            .offer(offer.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonHcxPropertiesArgs].
 */
@PulumiTagMarker
public class AddonHcxPropertiesArgsBuilder internal constructor() {
    private var addonType: Output<String>? = null

    private var offer: Output<String>? = null

    /**
     * @param value The type of private cloud addon
     * Expected value is 'HCX'.
     */
    @JvmName("jwprbpuqntqiylae")
    public suspend fun addonType(`value`: Output<String>) {
        this.addonType = value
    }

    /**
     * @param value The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
     */
    @JvmName("eqlmogrqpbuhgdwb")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value The type of private cloud addon
     * Expected value is 'HCX'.
     */
    @JvmName("snfwkyrpyhbwlwti")
    public suspend fun addonType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonType = mapped
    }

    /**
     * @param value The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
     */
    @JvmName("afrhtcpacnyxtkom")
    public suspend fun offer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    internal fun build(): AddonHcxPropertiesArgs = AddonHcxPropertiesArgs(
        addonType = addonType ?: throw PulumiNullFieldException("addonType"),
        offer = offer ?: throw PulumiNullFieldException("offer"),
    )
}
